﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/quicksight/QuickSight_EXPORTS.h>
#include <aws/quicksight/model/Visibility.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace QuickSight {
namespace Model {

/**
 * <p>The field label type.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/FieldLabelType">AWS
 * API Reference</a></p>
 */
class FieldLabelType {
 public:
  AWS_QUICKSIGHT_API FieldLabelType() = default;
  AWS_QUICKSIGHT_API FieldLabelType(Aws::Utils::Json::JsonView jsonValue);
  AWS_QUICKSIGHT_API FieldLabelType& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_QUICKSIGHT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Indicates the field that is targeted by the field label.</p>
   */
  inline const Aws::String& GetFieldId() const { return m_fieldId; }
  inline bool FieldIdHasBeenSet() const { return m_fieldIdHasBeenSet; }
  template <typename FieldIdT = Aws::String>
  void SetFieldId(FieldIdT&& value) {
    m_fieldIdHasBeenSet = true;
    m_fieldId = std::forward<FieldIdT>(value);
  }
  template <typename FieldIdT = Aws::String>
  FieldLabelType& WithFieldId(FieldIdT&& value) {
    SetFieldId(std::forward<FieldIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The visibility of the field label.</p>
   */
  inline Visibility GetVisibility() const { return m_visibility; }
  inline bool VisibilityHasBeenSet() const { return m_visibilityHasBeenSet; }
  inline void SetVisibility(Visibility value) {
    m_visibilityHasBeenSet = true;
    m_visibility = value;
  }
  inline FieldLabelType& WithVisibility(Visibility value) {
    SetVisibility(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_fieldId;

  Visibility m_visibility{Visibility::NOT_SET};
  bool m_fieldIdHasBeenSet = false;
  bool m_visibilityHasBeenSet = false;
};

}  // namespace Model
}  // namespace QuickSight
}  // namespace Aws
