#!/usr/bin/python3
# -*- coding: utf-8 -*-
#
# Copyright 2025 GNOME Foundation, Inc.
#
# SPDX-License-Identifier: GPL-2.0-or-later
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
# MA  02110-1301  USA

"""malcontent-webd mock template

This creates the expected method of the main org.freedesktop.MalcontentWeb1
object. You can dynamically change whether it returns success or an error using
`SetUpdateFiltersError()`.
"""

__author__ = "Philip Withnall"
__copyright__ = """
(c) 2025 GNOME Foundation, Inc.
"""

import dbus
import dbusmock

BUS_NAME = "org.freedesktop.MalcontentWeb1"
MAIN_OBJ = "/org/freedesktop/MalcontentWeb1"
MAIN_IFACE = "org.freedesktop.MalcontentWeb1.Filtering"
SYSTEM_BUS = True


def load(mock, _parameters):
    mock._update_filters_error_code = None
    mock._update_filters_error_message = None


@dbus.service.method(MAIN_IFACE, in_signature="u", out_signature="")
def UpdateFilters(self, uid):
    if self._update_filters_error_code and self._update_filters_error_message:
        raise dbus.exceptions.DBusException(
            self._update_filters_error_message, name=self._update_filters_error_code
        )

    return None


@dbus.service.method(dbusmock.MOCK_IFACE, in_signature="ss", out_signature="")
def SetUpdateFiltersError(self, error_code, error_message):
    self._update_filters_error_code = error_code if error_code != "" else None
    self._update_filters_error_message = error_message if error_message != "" else None
