/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.documentgroup;

import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.core.WindowSystem;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.PersistenceHandler;
import org.netbeans.core.windows.Switches;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.documentgroup.DocumentGroupImpl;
import org.netbeans.core.windows.persistence.ModeConfig;
import org.netbeans.core.windows.persistence.PersistenceManager;
import org.netbeans.core.windows.persistence.WindowManagerParser;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.InstanceDataObject;
import org.openide.modules.Places;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class GroupsManager {
    private static GroupsManager theInstance;
    private static final String SEL_GROUP = "selectedDocumentGroup";
    private static final String DEFAULT_GROUP_NAME = "group";
    private static final String DISPLAY_NAME = "displayName";
    private static final String CONFIG = "config";
    private static final String SETTINGS = "settings";
    private static final String WSMODE = "wsmode";
    private static final String WINDOWS2_LOCAL = "Windows2Local";
    private static final String COMPONENTS = "Components";
    private static final String MODES = "Modes";
    private static final String DOCUMENT_GROUPS = "DocumentGroups";
    private static final String ID_SEPARATOR = ":";
    private static final String SELECTED_ID = "_selectedId";
    private static final Logger LOG;

    private GroupsManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GroupsManager getDefault() {
        Class<GroupsManager> clazz = GroupsManager.class;
        synchronized (GroupsManager.class) {
            if (null == theInstance) {
                theInstance = new GroupsManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return theInstance;
        }
    }

    void addGroup(String string) {
        Preferences preferences = GroupsManager.getPreferences();
        int n = this.getGroups().size();
        String string2 = DEFAULT_GROUP_NAME + n;
        try {
            while (preferences.nodeExists(string2 = DEFAULT_GROUP_NAME + ++n)) {
            }
        }
        catch (BackingStoreException backingStoreException) {
            LOG.log(Level.INFO, null, backingStoreException);
        }
        preferences.put(SEL_GROUP, string2);
        preferences.node(string2).put(DISPLAY_NAME, string);
    }

    void removeAllGroups() {
        List<DocumentGroupImpl> list = this.getGroups();
        for (DocumentGroupImpl documentGroupImpl : list) {
            this.removeGroup(documentGroupImpl);
        }
    }

    DocumentGroupImpl getCurrentGroup() {
        String string = GroupsManager.getPreferences().get(SEL_GROUP, "");
        return string.isEmpty() ? null : this.createGroup(string);
    }

    private DocumentGroupImpl createGroup(String string) {
        Preferences preferences = GroupsManager.getPreferences().node(string);
        String string2 = preferences.get(DISPLAY_NAME, string);
        return new DocumentGroupImpl(string, string2);
    }

    List<DocumentGroupImpl> getGroups() {
        Preferences preferences = GroupsManager.getPreferences();
        try {
            String[] stringArray = preferences.childrenNames();
            ArrayList<DocumentGroupImpl> arrayList = new ArrayList<DocumentGroupImpl>(stringArray.length);
            for (String string : stringArray) {
                arrayList.add(this.createGroup(string));
            }
            Collections.sort(arrayList);
            return arrayList;
        }
        catch (BackingStoreException backingStoreException) {
            LOG.log(Level.INFO, null, backingStoreException);
            return Collections.emptyList();
        }
    }

    static Preferences getPreferences() {
        return NbPreferences.forModule(DocumentGroupImpl.class).node(DOCUMENT_GROUPS);
    }

    /*
     * WARNING - void declaration
     */
    boolean openGroup(DocumentGroupImpl documentGroupImpl) {
        Object object222;
        DocumentGroupImpl documentGroupImpl2 = this.getCurrentGroup();
        if (null != documentGroupImpl2 && !documentGroupImpl2.close()) {
            return false;
        }
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        for (Object object222 : TopComponent.getRegistry().getOpened()) {
            if (!windowManagerImpl.isEditorTopComponent((TopComponent)object222) || object222.close()) continue;
            return false;
        }
        ArrayList arrayList = new ArrayList(10);
        for (ModeImpl object3 : windowManagerImpl.getModes()) {
            if (object3.isPermanent() || object3.getKind() != 1 || !object3.getOpenedTopComponentsIDs().isEmpty()) continue;
            arrayList.add(object3);
        }
        object222 = arrayList.iterator();
        while (object222.hasNext()) {
            ModeImpl modeImpl = (ModeImpl)object222.next();
            windowManagerImpl.removeMode(modeImpl);
        }
        object222 = documentGroupImpl.getName();
        Preferences preferences = GroupsManager.getPreferences().node((String)object222);
        File file = Places.getUserDirectory();
        File file2 = new File(new File(file, CONFIG), DOCUMENT_GROUPS);
        File file3 = new File(file2, (String)object222);
        FileObject fileObject = FileUtil.toFileObject((File)file3);
        if (null != fileObject) {
            void var18_28;
            Object object;
            Object object2;
            Object object32;
            HashMap<void, ModeConfig> hashMap = new HashMap<void, ModeConfig>(10);
            HashMap<TopComponent, void> hashMap2 = new HashMap<TopComponent, void>(50);
            for (Object object32 : fileObject.getChildren()) {
                if (!object32.isData() || !WSMODE.equals(object32.getExt())) continue;
                try {
                    void var19_31;
                    ModeConfig modeConfig = WindowManagerParser.loadModeConfigFrom((FileObject)object32);
                    String modeImpl = preferences.get(modeConfig.name, "");
                    if (modeImpl.isEmpty()) continue;
                    ModeImpl modeImpl2 = (ModeImpl)windowManagerImpl.findMode(modeConfig.name);
                    if (null == modeImpl2) {
                        ModeImpl modeImpl3 = this.createMode(modeConfig);
                    } else {
                        modeImpl2.setConstraints(modeConfig.constraints);
                    }
                    hashMap.put(var19_31, modeConfig);
                    object2 = modeImpl.split(ID_SEPARATOR);
                    object = object2;
                    int n = ((TopComponent)object).length;
                    for (int i = 0; i < n; ++i) {
                        TopComponent topComponent = object[i];
                        hashMap2.put(topComponent, var19_31);
                        var19_31.addUnloadedTopComponent((String)topComponent);
                    }
                }
                catch (IOException iOException) {
                    LOG.log(Level.INFO, null, iOException);
                }
            }
            DataLoader dataLoader = null;
            Enumeration enumeration = DataLoaderPool.getDefault().producersOf(InstanceDataObject.class);
            while (enumeration.hasMoreElements()) {
                dataLoader = (DataLoader)enumeration.nextElement();
            }
            HashMap<String, TopComponent> hashMap3 = new HashMap<String, TopComponent>(50);
            object32 = fileObject.getChildren();
            int n = ((FileObject[])object32).length;
            boolean bl = false;
            while (var18_28 < n) {
                FileObject fileObject2 = object32[var18_28];
                if (fileObject2.isData() && SETTINGS.equals(fileObject2.getExt())) {
                    try {
                        Object object4;
                        DataLoaderPool.setPreferredLoader((FileObject)fileObject2, (DataLoader)dataLoader);
                        object2 = DataObject.find((FileObject)fileObject2);
                        DataLoaderPool.setPreferredLoader((FileObject)fileObject2, null);
                        object = (InstanceCookie)object2.getCookie(InstanceCookie.class);
                        if (null != object) {
                            object4 = (TopComponent)object.instanceCreate();
                            hashMap3.put(fileObject2.getName(), (TopComponent)object4);
                        } else {
                            object4 = NbBundle.getMessage(PersistenceManager.class, (String)"EXC_BrokenTCSetting", (Object)fileObject2.getName());
                            LOG.log(Level.INFO, "[PersistenceManager.getTopComponentForID] Problem when deserializing TopComponent for tcID:'" + fileObject2.getName() + "'. Reason: " + (String)object4);
                        }
                    }
                    catch (Exception exception) {
                        LOG.log(Level.INFO, null, exception);
                    }
                }
                ++var18_28;
            }
            object32 = new HashMap(hashMap3.size());
            for (Map.Entry entry : hashMap3.entrySet()) {
                String string = (String)entry.getKey();
                object2 = (TopComponent)entry.getValue();
                object = (ModeImpl)hashMap2.get(string);
                if (null != object) {
                    ((ModeImpl)object).dockInto((TopComponent)object2);
                }
                object2.open();
                object32.put(string, windowManagerImpl.findTopComponentID((TopComponent)object2));
            }
            for (ModeImpl modeImpl : windowManagerImpl.getModes()) {
                ModeConfig modeConfig = (ModeConfig)hashMap.get(modeImpl);
                if (null == modeConfig) continue;
                object2 = modeConfig.selectedTopComponentID;
                if (null != object2) {
                    object2 = (String)object32.get(object2);
                }
                if (null == object2 || !modeImpl.getOpenedTopComponentsIDs().contains(object2) || null == (object = windowManagerImpl.findTopComponent((String)object2))) continue;
                modeImpl.setSelectedTopComponent((TopComponent)object);
            }
        }
        GroupsManager.getPreferences().put(SEL_GROUP, documentGroupImpl.getName());
        return true;
    }

    boolean closeGroup(DocumentGroupImpl documentGroupImpl) {
        StringBuilder stringBuilder;
        String string;
        Object object22;
        TopComponent topComponent = WindowManager.getDefault().findTopComponent("Welcome");
        boolean bl = null != topComponent && topComponent.isOpened();
        ((WindowSystem)Lookup.getDefault().lookup(WindowSystem.class)).save();
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        ArrayList<TopComponent> arrayList = new ArrayList<TopComponent>(TopComponent.getRegistry().getOpened().size());
        for (Object object22 : TopComponent.getRegistry().getOpened()) {
            if (!windowManagerImpl.isEditorTopComponent((TopComponent)object22)) continue;
            arrayList.add((TopComponent)object22);
        }
        String string2 = documentGroupImpl.getName();
        object22 = Places.getUserDirectory();
        File file = new File(new File((File)object22, CONFIG), DOCUMENT_GROUPS);
        File file2 = new File(file, string2);
        GroupsManager.deleteAll(file2);
        file2.mkdirs();
        FileObject fileObject = FileUtil.toFileObject((File)file2);
        Preferences preferences = GroupsManager.getPreferences().node(string2);
        try {
            preferences.clear();
        }
        catch (BackingStoreException backingStoreException) {
            LOG.log(Level.INFO, null, backingStoreException);
        }
        preferences.put(DISPLAY_NAME, documentGroupImpl.toString());
        File file3 = new File(new File(Places.getUserDirectory(), CONFIG), WINDOWS2_LOCAL);
        File file4 = new File(file3, MODES);
        for (ModeImpl object3 : windowManagerImpl.getModes()) {
            String string3;
            if (object3.getKind() != 1 || null == (string = FileUtil.toFileObject((File)new File(file4, (string3 = object3.getName()) + "." + WSMODE)))) continue;
            try {
                string.copy(fileObject, string3, WSMODE);
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, null, iOException);
                continue;
            }
            stringBuilder = new StringBuilder();
            for (String string4 : object3.getOpenedTopComponentsIDs()) {
                stringBuilder.append(string4);
                stringBuilder.append(ID_SEPARATOR);
            }
            preferences.put(string3, stringBuilder.toString());
        }
        File file5 = new File(file3, COMPONENTS);
        for (TopComponent topComponent2 : arrayList) {
            string = windowManagerImpl.findTopComponentID(topComponent2);
            if (topComponent2.equals(topComponent) && !bl || topComponent2.getPersistenceType() == 2 || (stringBuilder = FileUtil.toFileObject((File)new File(file5, string + "." + SETTINGS))) == null) continue;
            try {
                stringBuilder.copy(fileObject, string, SETTINGS);
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, null, iOException);
            }
        }
        GroupsManager.getPreferences().put(SEL_GROUP, "");
        return true;
    }

    private ModeImpl createMode(ModeConfig modeConfig) {
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        ModeImpl modeImpl = windowManagerImpl.createMode(modeConfig.name, modeConfig.kind, modeConfig.state, false, modeConfig.constraints);
        Rectangle rectangle = modeConfig.bounds == null ? new Rectangle() : modeConfig.bounds;
        Rectangle rectangle2 = modeConfig.relativeBounds == null ? new Rectangle() : modeConfig.relativeBounds;
        Rectangle rectangle3 = PersistenceHandler.computeBounds(false, false, rectangle.x, rectangle.y, rectangle.width, rectangle.height, (float)rectangle2.x / 100.0f, (float)rectangle2.y / 100.0f, (float)rectangle2.width / 100.0f, (float)rectangle2.height / 100.0f);
        modeImpl.setBounds(rectangle3);
        modeImpl.setFrameState(modeConfig.frameState);
        modeImpl.setMinimized(modeConfig.minimized);
        return modeImpl;
    }

    void removeGroup(DocumentGroupImpl documentGroupImpl) {
        try {
            Preferences preferences = GroupsManager.getPreferences();
            if (documentGroupImpl.getName().equals(preferences.get(SEL_GROUP, ""))) {
                preferences.put(SEL_GROUP, "");
            }
            preferences = preferences.node(documentGroupImpl.getName());
            preferences.removeNode();
        }
        catch (Exception exception) {
            LOG.log(Level.INFO, "Failed to remove document group '" + documentGroupImpl.toString() + "'", exception);
        }
    }

    private static void deleteAll(File file) {
        File[] fileArray = file.listFiles();
        if (null == fileArray) {
            return;
        }
        for (File file2 : fileArray) {
            if (file2.isDirectory()) {
                GroupsManager.deleteAll(file2);
            }
            file2.delete();
        }
    }

    static boolean closeAllDocuments() {
        TopComponent[] topComponentArray;
        for (TopComponent topComponent : topComponentArray = WindowManagerImpl.getInstance().getEditorTopComponents()) {
            if (!Switches.isClosingEnabled(topComponent)) continue;
            topComponent.putClientProperty((Object)"inCloseAll", (Object)Boolean.TRUE);
            if (topComponent.close()) continue;
            return false;
        }
        return true;
    }

    static {
        LOG = Logger.getLogger(GroupsManager.class.getName());
    }
}

