/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.io;

import com.eteks.sweethome3d.tools.URLContent;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

class ResourceBundleTools {
    private ResourceBundleTools() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ResourceBundle getBundle(URL uRL, String string) {
        Locale locale = Locale.getDefault();
        String string2 = locale.getLanguage();
        String string3 = locale.getCountry();
        String[] stringArray = new String[]{".properties", "_" + string2 + ".properties", "_" + string2 + "_" + string3 + ".properties"};
        PropertyResourceBundle propertyResourceBundle = null;
        for (String string4 : stringArray) {
            try {
                URLContent uRLContent = new URLContent(new URL("jar:" + uRL.toURI() + "!/" + string + string4));
                InputStream inputStream = uRLContent.openStream();
                if (inputStream == null) continue;
                final PropertyResourceBundle propertyResourceBundle2 = propertyResourceBundle;
                try {
                    propertyResourceBundle = new PropertyResourceBundle(inputStream){
                        {
                            super(inputStream);
                            this.setParent(propertyResourceBundle2);
                        }
                    };
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    illegalArgumentException.printStackTrace();
                }
                finally {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (propertyResourceBundle != null) {
            return propertyResourceBundle;
        }
        throw new MissingResourceException("Can't find bundle for base name " + string, string, "");
    }

    static String getOptionalString(ResourceBundle resourceBundle, String string, String string2) {
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string2;
        }
    }

    static float getOptionalFloat(ResourceBundle resourceBundle, String string, float f) {
        try {
            return Float.parseFloat(resourceBundle.getString(string));
        }
        catch (MissingResourceException missingResourceException) {
            return f;
        }
    }

    static boolean getOptionalBoolean(ResourceBundle resourceBundle, String string, boolean bl) {
        try {
            return Boolean.parseBoolean(resourceBundle.getString(string));
        }
        catch (MissingResourceException missingResourceException) {
            return bl;
        }
    }
}

