/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.RowSetReader;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.rowset.OracleCachedRowSet;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.ROWSET})
public class OracleCachedRowSetReader
implements RowSetReader,
Serializable,
Monitor {
    static final long serialVersionUID = -3565405169674271176L;
    static final transient int SETUNICODESTREAM_INTLENGTH = 1;
    static final transient int SETBINARYSTREAM_INTLENGTH = 2;
    static final transient int SETASCIISTREAM_INTLENGTH = 3;
    static final transient int SETCHARACTERSTREAM_INTLENGTH = 4;
    static final transient int SETBINARYSTREAM = 5;
    static final transient int SETBINARYSTREAM_LONGLENGTH = 6;
    static final transient int SETASCIISTREAM = 7;
    static final transient int SETASCIISTREAM_LONGLENGTH = 8;
    static final transient int SETCHARACTERSTREAM = 9;
    static final transient int SETCHARACTERSTREAM_LONGLENGTH = 10;
    static final transient int SETNCHARACTERSTREAM = 11;
    static final transient int SETNCHARACTERSTREAM_LONGLENGTH = 12;
    static final transient int SETBLOB_STREAM = 13;
    static final transient int SETBLOB_STREAM_LONG = 14;
    static final transient int SETCLOB_READER = 15;
    static final transient int SETCLOB_READER_LONG = 16;
    static final transient int SETNCLOB_READER = 17;
    static final transient int SETNCLOB_READER_LONG = 18;
    static final transient int TWO_PARAMETERS = 2;
    static final transient int THREE_PARAMETERS = 3;
    private static transient boolean driverManagerInitialized;
    private final Monitor.CloseableLock monitorLock;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;

    public OracleCachedRowSetReader() {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleCachedRowSetReader.class, $$$methodRef$$$5, null, new Object[0]);
            }
            this.monitorLock = this.newDefaultLock();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleCachedRowSetReader.class, $$$methodRef$$$5, null);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleCachedRowSetReader.class, $$$methodRef$$$5, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleCachedRowSetReader.class, $$$methodRef$$$5, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    Connection getConnection(RowSetInternal rowSetInternal) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void rowsetInternal;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleCachedRowSetReader.class, $$$methodRef$$$0, this, rowSetInternal);
            }
            Connection con = null;
            Connection rowsetConnection = rowsetInternal.getConnection();
            if (rowsetConnection != null && !rowsetConnection.isClosed()) {
                con = rowsetConnection;
                if (bl) {
                    this.debug($$$loggerRef$$$0, Level.FINEST, $$$methodRef$$$0, "OracleCachedRowSetReader.getConnection(RowSetInternal),con=" + con);
                }
            } else if (((RowSet)rowsetInternal).getDataSourceName() != null) {
                try {
                    InitialContext initialcontext = null;
                    try {
                        Properties props = System.getProperties();
                        initialcontext = new InitialContext(props);
                        if (bl) {
                            this.debug($$$loggerRef$$$0, Level.FINEST, $$$methodRef$$$0, "OracleCachedRowSetReader.getConnection(), initialcontext=" + initialcontext);
                        }
                    }
                    catch (SecurityException props) {
                        // empty catch block
                    }
                    if (initialcontext == null) {
                        initialcontext = new InitialContext();
                    }
                    DataSource datasource = (DataSource)initialcontext.lookup(((RowSet)rowsetInternal).getDataSourceName());
                    if (bl) {
                        this.debug($$$loggerRef$$$0, Level.FINEST, $$$methodRef$$$0, "OracleCachedRowSetReader.getConnection(),datasource=" + datasource);
                    }
                    String userName = ((RowSet)rowsetInternal).getUsername();
                    String password = ((RowSet)rowsetInternal).getPassword();
                    if (userName == null && password == null) {
                        con = datasource.getConnection();
                    }
                    con = datasource.getConnection(userName, password);
                }
                catch (NamingException ea) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(null, 300, ea.getMessage()).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleCachedRowSetReader.class, $$$methodRef$$$0, this, sQLException);
                    }
                    throw sQLException;
                }
            } else if (((RowSet)rowsetInternal).getUrl() != null) {
                if (!driverManagerInitialized) {
                    DriverManager.registerDriver(new OracleDriver());
                    driverManagerInitialized = true;
                }
                String url = ((RowSet)rowsetInternal).getUrl();
                String userName = ((RowSet)rowsetInternal).getUsername();
                String password = ((RowSet)rowsetInternal).getPassword();
                if (bl) {
                    this.debug($$$loggerRef$$$0, Level.FINEST, $$$methodRef$$$0, "OracleCachedRowSetReader.getConnection(): url = " + url + ", userName = " + userName + ", password = " + password);
                }
                if (url.equals("") || userName.equals("") || password.equals("")) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(301).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleCachedRowSetReader.class, $$$methodRef$$$0, this, sQLException);
                    }
                    throw sQLException;
                }
                con = DriverManager.getConnection(url, userName, password);
            }
            Connection connection = con;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleCachedRowSetReader.class, $$$methodRef$$$0, this, connection);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleCachedRowSetReader.class, $$$methodRef$$$0, this, null);
            }
            return connection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleCachedRowSetReader.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setParams(Object[] objectArray, PreparedStatement preparedStatement) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void paramObject;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleCachedRowSetReader.class, $$$methodRef$$$1, this, objectArray, preparedStatement);
            }
            block30: for (int j2 = 0; j2 < ((void)paramObject).length; ++j2) {
                void preparedStatement2;
                int i2 = 0;
                if (bl) {
                    this.debug($$$loggerRef$$$1, Level.FINEST, $$$methodRef$$$1, "OracleCachedRowSetReader.setParams(Object[], PreparedStatement), inside for-loop, i=" + i2);
                }
                if (paramObject[j2] instanceof byte[]) {
                    preparedStatement2.setObject(j2 + 1, paramObject[j2]);
                    continue;
                }
                try {
                    i2 = Array.getLength(paramObject[j2]);
                }
                catch (IllegalArgumentException ex) {
                    preparedStatement2.setObject(j2 + 1, paramObject[j2]);
                    continue;
                }
                Object[] tmpParmObj = (Object[])paramObject[j2];
                if (bl) {
                    this.debug($$$loggerRef$$$1, Level.FINEST, $$$methodRef$$$1, "OracleCachedRowSetReader.setParams(Object[], PreparedStatement), inside for-loop, Object tmpParmObj=" + tmpParmObj);
                }
                if (i2 == 2) {
                    if (tmpParmObj[0] == null) {
                        preparedStatement2.setNull(j2 + 1, (Integer)tmpParmObj[1]);
                        continue;
                    }
                    if (tmpParmObj[0] instanceof Date) {
                        if (tmpParmObj[1] instanceof Calendar) {
                            preparedStatement2.setDate(j2 + 1, (Date)tmpParmObj[0], (Calendar)tmpParmObj[1]);
                            continue;
                        }
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(323).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleCachedRowSetReader.class, $$$methodRef$$$1, this, sQLException);
                        }
                        throw sQLException;
                    }
                    if (tmpParmObj[0] instanceof Time) {
                        if (tmpParmObj[1] instanceof Calendar) {
                            preparedStatement2.setTime(j2 + 1, (Time)tmpParmObj[0], (Calendar)tmpParmObj[1]);
                            continue;
                        }
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(323).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleCachedRowSetReader.class, $$$methodRef$$$1, this, sQLException);
                        }
                        throw sQLException;
                    }
                    if (tmpParmObj[0] instanceof Timestamp) {
                        if (tmpParmObj[1] instanceof Calendar) {
                            preparedStatement2.setTimestamp(j2 + 1, (Timestamp)tmpParmObj[0], (Calendar)tmpParmObj[1]);
                            continue;
                        }
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(323).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleCachedRowSetReader.class, $$$methodRef$$$1, this, sQLException);
                        }
                        throw sQLException;
                    }
                    if (tmpParmObj[0] instanceof Reader) {
                        switch ((Integer)tmpParmObj[1]) {
                            case 9: {
                                preparedStatement2.setCharacterStream(j2 + 1, (Reader)tmpParmObj[0]);
                                continue block30;
                            }
                            case 11: {
                                preparedStatement2.setNCharacterStream(j2 + 1, (Reader)tmpParmObj[0]);
                                continue block30;
                            }
                            case 15: {
                                preparedStatement2.setClob(j2 + 1, (Reader)tmpParmObj[0]);
                                continue block30;
                            }
                            case 17: {
                                preparedStatement2.setNClob(j2 + 1, (Reader)tmpParmObj[0]);
                                continue block30;
                            }
                            default: {
                                SQLException sQLException = (SQLException)DatabaseError.createSqlException(323).fillInStackTrace();
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleCachedRowSetReader.class, $$$methodRef$$$1, this, sQLException);
                                }
                                throw sQLException;
                            }
                        }
                    }
                    if (tmpParmObj[0] instanceof InputStream) {
                        switch ((Integer)tmpParmObj[1]) {
                            case 7: {
                                preparedStatement2.setAsciiStream(j2 + 1, (InputStream)tmpParmObj[0]);
                                continue block30;
                            }
                            case 5: {
                                preparedStatement2.setBinaryStream(j2 + 1, (InputStream)tmpParmObj[0]);
                                continue block30;
                            }
                            case 13: {
                                preparedStatement2.setBlob(j2 + 1, (InputStream)tmpParmObj[0]);
                                continue block30;
                            }
                            default: {
                                SQLException sQLException = (SQLException)DatabaseError.createSqlException(323).fillInStackTrace();
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleCachedRowSetReader.class, $$$methodRef$$$1, this, sQLException);
                                }
                                throw sQLException;
                            }
                        }
                    }
                    if (!(tmpParmObj[1] instanceof Integer)) continue;
                    preparedStatement2.setObject(j2 + 1, tmpParmObj[0], (Integer)tmpParmObj[1]);
                    continue;
                }
                if (i2 != 3) continue;
                if (tmpParmObj[0] == null) {
                    preparedStatement2.setNull(j2 + 1, (Integer)tmpParmObj[1], (String)tmpParmObj[2]);
                    continue;
                }
                if (tmpParmObj[0] instanceof Reader) {
                    switch ((Integer)tmpParmObj[2]) {
                        case 4: {
                            preparedStatement2.setCharacterStream(j2 + 1, (Reader)tmpParmObj[0], (Integer)tmpParmObj[1]);
                            continue block30;
                        }
                        case 10: {
                            preparedStatement2.setCharacterStream(j2 + 1, (Reader)tmpParmObj[0], (Long)tmpParmObj[1]);
                            continue block30;
                        }
                        case 12: {
                            preparedStatement2.setNCharacterStream(j2 + 1, (Reader)tmpParmObj[0], (Long)tmpParmObj[1]);
                            continue block30;
                        }
                        case 16: {
                            preparedStatement2.setClob(j2 + 1, (Reader)tmpParmObj[0], (Long)tmpParmObj[1]);
                            continue block30;
                        }
                        case 18: {
                            preparedStatement2.setNClob(j2 + 1, (Reader)tmpParmObj[0], (Long)tmpParmObj[1]);
                            continue block30;
                        }
                        default: {
                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(323).fillInStackTrace();
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleCachedRowSetReader.class, $$$methodRef$$$1, this, sQLException);
                            }
                            throw sQLException;
                        }
                    }
                }
                if (tmpParmObj[0] instanceof InputStream) {
                    switch ((Integer)tmpParmObj[2]) {
                        case 1: {
                            preparedStatement2.setUnicodeStream(j2 + 1, (InputStream)tmpParmObj[0], (Integer)tmpParmObj[1]);
                            continue block30;
                        }
                        case 2: {
                            preparedStatement2.setBinaryStream(j2 + 1, (InputStream)tmpParmObj[0], (Integer)tmpParmObj[1]);
                            continue block30;
                        }
                        case 3: {
                            preparedStatement2.setAsciiStream(j2 + 1, (InputStream)tmpParmObj[0], (Integer)tmpParmObj[1]);
                            continue block30;
                        }
                        case 6: {
                            preparedStatement2.setBinaryStream(j2 + 1, (InputStream)tmpParmObj[0], (Long)tmpParmObj[1]);
                            continue block30;
                        }
                        case 8: {
                            preparedStatement2.setAsciiStream(j2 + 1, (InputStream)tmpParmObj[0], (Long)tmpParmObj[1]);
                            continue block30;
                        }
                        case 14: {
                            preparedStatement2.setBlob(j2 + 1, (InputStream)tmpParmObj[0], (Long)tmpParmObj[1]);
                            continue block30;
                        }
                        default: {
                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(323).fillInStackTrace();
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleCachedRowSetReader.class, $$$methodRef$$$1, this, sQLException);
                            }
                            throw sQLException;
                        }
                    }
                }
                if (tmpParmObj[1] instanceof Integer && tmpParmObj[2] instanceof Integer) {
                    preparedStatement2.setObject(j2 + 1, tmpParmObj[0], (Integer)tmpParmObj[1], (int)((Integer)tmpParmObj[2]));
                    continue;
                }
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(323).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleCachedRowSetReader.class, $$$methodRef$$$1, this, sQLException);
                }
                throw sQLException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleCachedRowSetReader.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleCachedRowSetReader.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleCachedRowSetReader.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void readData(RowSetInternal rowSetInternal) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleCachedRowSetReader.class, $$$methodRef$$$2, this, rowSetInternal);
            }
            Monitor.CloseableLock lock = this.acquireCloseableLock();
            try {
                Connection connection;
                OracleCachedRowSet rowset;
                void rowsetInternal;
                block24: {
                    rowset = (OracleCachedRowSet)rowsetInternal;
                    connection = this.getConnection((RowSetInternal)rowsetInternal);
                    if (bl) {
                        this.debug($$$loggerRef$$$2, Level.FINEST, $$$methodRef$$$2, "OracleCachedRowSetReader.readData(), connection=" + connection);
                    }
                    if (connection == null || rowset.getCommand() == null) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(342).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleCachedRowSetReader.class, $$$methodRef$$$2, this, sQLException);
                        }
                        throw sQLException;
                    }
                    try {
                        connection.setTransactionIsolation(rowset.getTransactionIsolation());
                    }
                    catch (Exception ex) {
                        if (!bl) break block24;
                        this.debug($$$loggerRef$$$2, Level.FINEST, $$$methodRef$$$2, "OracleCachedRowSetReader.readData(), setTransactionIsolation() throws exception: " + ex);
                    }
                }
                PreparedStatement preparedStatement = connection.prepareStatement(rowset.getCommand(), rowset.getType(), rowset.getConcurrency());
                if (bl) {
                    this.debug($$$loggerRef$$$2, Level.FINEST, $$$methodRef$$$2, "OracleCachedRowSetReader.readData(), preparedStatement=" + preparedStatement);
                }
                this.setParams(rowsetInternal.getParams(), preparedStatement);
                try {
                    preparedStatement.setMaxRows(rowset.getMaxRows());
                    preparedStatement.setMaxFieldSize(rowset.getMaxFieldSize());
                    preparedStatement.setEscapeProcessing(rowset.getEscapeProcessing());
                    preparedStatement.setQueryTimeout(rowset.getQueryTimeout());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ResultSet resultset = preparedStatement.executeQuery();
                rowset.populate(resultset, rowset.getCurrentPage() * rowset.getPageSize());
                resultset.close();
                preparedStatement.close();
                try {
                    if (!connection.getAutoCommit()) {
                        connection.commit();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (!rowset.isConnectionStayingOpen()) {
                    connection.close();
                }
                if (lock != null) {
                    lock.close();
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                Throwable throwable3 = throwable;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleCachedRowSetReader.class, $$$methodRef$$$2, this, throwable3);
                }
                throw throwable3;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleCachedRowSetReader.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleCachedRowSetReader.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleCachedRowSetReader.class, $$$methodRef$$$2, this, throwable4);
            }
            throw throwable;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleCachedRowSetReader.class, $$$methodRef$$$3, this, new Object[0]);
            }
            OracleConnection oracleConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleCachedRowSetReader.class, $$$methodRef$$$3, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleCachedRowSetReader.class, $$$methodRef$$$3, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleCachedRowSetReader.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleCachedRowSetReader.class, $$$methodRef$$$4, this, new Object[0]);
            }
            Monitor.CloseableLock closeableLock = this.monitorLock;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleCachedRowSetReader.class, $$$methodRef$$$4, this, closeableLock);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleCachedRowSetReader.class, $$$methodRef$$$4, this, null);
            }
            return closeableLock;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleCachedRowSetReader.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$5 = OracleCachedRowSetReader.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleCachedRowSetReader.class.getDeclaredMethod("getMonitorLock", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleCachedRowSetReader.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleCachedRowSetReader.class.getDeclaredMethod("readData", RowSetInternal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleCachedRowSetReader.class.getDeclaredMethod("setParams", Object[].class, PreparedStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleCachedRowSetReader.class.getDeclaredMethod("getConnection", RowSetInternal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        driverManagerInitialized = false;
    }
}

