/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.utility;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import schemacrawler.schema.Catalog;
import schemacrawler.utility.SerializedObjectInputStream;

public final class SerializedCatalogUtility {
    private static final List<Pattern> CATALOG_CLASS_PATTERNS = List.of(Pattern.compile("us\\.fatehi\\.utility\\.property\\.[A-Z].*"), Pattern.compile("us\\.fatehi\\.utility\\.database\\.[A-Z].*"), Pattern.compile("schemacrawler\\.(schema(crawler)?|crawl)\\.[A-Z].*"), Pattern.compile("schemacrawler\\.[A-Z].*"), Pattern.compile("(\\[L)?java\\.(lang|util)\\..*"), Pattern.compile("java\\.(sql|math|time|net)\\..*"), Pattern.compile("\\[[BC]"));

    public static Catalog readCatalog(InputStream in) {
        Objects.requireNonNull(in, "No input stream provided");
        return (Catalog)SerializedObjectInputStream.read(in, CATALOG_CLASS_PATTERNS);
    }

    public static void saveCatalog(Catalog catalog, OutputStream out) {
        Objects.requireNonNull(catalog, "No catalog provided");
        Objects.requireNonNull(out, "No output stream provided");
        SerializedObjectInputStream.save(catalog, out);
    }

    private SerializedCatalogUtility() {
    }
}

