/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.util;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.complex.PComplex;
import com.oracle.graal.python.lib.PyFloatAsDoubleNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.truffle.PythonIntegerAndFloatTypes;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@GenerateInline
@GenerateCached(value=false)
@TypeSystemReference(value=PythonIntegerAndFloatTypes.class)
@ImportStatic(value={PGuards.class})
public abstract class CoerceToComplexNode
extends PNodeWithContext {
    public abstract PComplex execute(VirtualFrame var1, Node var2, Object var3);

    @Specialization
    static PComplex doLong(long x, @Bind PythonLanguage language) {
        return PFactory.createComplex(language, x, 0.0);
    }

    @Specialization
    static PComplex doDouble(double x, @Bind PythonLanguage language) {
        return PFactory.createComplex(language, x, 0.0);
    }

    @Specialization
    static PComplex doComplex(PComplex x) {
        return x;
    }

    @Specialization(guards={"!isPComplex(x)"})
    static PComplex toComplex(VirtualFrame frame, Node inliningTarget, Object x, @Cached(value="create(T___COMPLEX__)", inline=false) LookupAndCallUnaryNode callComplexFunc, @Cached PyFloatAsDoubleNode asDoubleNode, @Bind PythonLanguage language, @Cached PRaiseNode raiseNode) {
        Object result = callComplexFunc.executeObject(frame, x);
        if (result != PNone.NO_VALUE) {
            if (result instanceof PComplex) {
                return (PComplex)result;
            }
            throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.SHOULD_RETURN, "__complex__", "complex object");
        }
        return PFactory.createComplex(language, asDoubleNode.execute(frame, inliningTarget, x), 0.0);
    }
}

