/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.linter;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.filter.TableTypesFilter;
import schemacrawler.schema.Identifiers;
import schemacrawler.schema.IdentifiersBuilder;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.QueryUtility;
import schemacrawler.tools.lint.BaseLinter;
import schemacrawler.tools.lint.LintCollector;
import schemacrawler.tools.lint.LintSeverity;
import us.fatehi.utility.property.PropertyName;
import us.fatehi.utility.string.StringFormat;

class LinterTableEmpty
extends BaseLinter {
    private static final Logger LOGGER = Logger.getLogger(LinterTableEmpty.class.getName());

    public LinterTableEmpty(PropertyName propertyName, LintCollector lintCollector) {
        super(propertyName, lintCollector);
        this.setSeverity(LintSeverity.low);
        this.setTableTypesFilter(new TableTypesFilter(new String[]{"TABLE"}));
    }

    @Override
    public String getSummary() {
        return "empty table";
    }

    public boolean usesConnection() {
        return true;
    }

    @Override
    protected void lint(Table table, Connection connection) {
        Objects.requireNonNull(table, "No table provided");
        Objects.requireNonNull(connection, "c");
        Query query = new Query("Count", "SELECT COUNT(*) FROM ${table}");
        try {
            Identifiers identifiers = IdentifiersBuilder.builder().fromConnection(connection).toOptions();
            long count = QueryUtility.executeForLong((Query)query, (Connection)connection, (Table)table, (Identifiers)identifiers);
            if (count == 0L) {
                this.addTableLint(table, this.getSummary());
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, e, (Supplier<String>)new StringFormat("Could not get count for table, ", new Object[]{table}));
        }
    }
}

