/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jaybird.xca;

import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Set;

public final class FatalErrorHelper {
    private static final int[] FATAL_ERRORS = new int[]{335544721, 335544726, 335544727, 335544344, 335544357, 335544364, 335544375, 335544441, 335544528, 335544781, 335544856, 335544741};
    private static final int[] BROKEN_CONNECTION_ERRORS = new int[]{335544721, 335544726, 335544727, 335544375, 335544528, 335544781, 335544856};
    private static final Set<String> FATAL_SQL_STATE_CLASSES = Set.of("08");
    private static final Set<String> FATAL_SQL_STATES = Set.of("2E000", "HY001", "HYT00", "HYT01");

    public static boolean isFatal(SQLException exception) {
        return exception != null && (FatalErrorHelper.isFatal(exception.getErrorCode()) || FatalErrorHelper.isFatal(exception.getSQLState()));
    }

    private static boolean isFatal(int errorCode) {
        return Arrays.binarySearch(FATAL_ERRORS, errorCode) >= 0;
    }

    private static boolean isFatal(String sqlState) {
        if (sqlState == null) {
            return false;
        }
        if (sqlState.length() != 5) {
            return true;
        }
        return FATAL_SQL_STATES.contains(sqlState) || FATAL_SQL_STATE_CLASSES.contains(sqlState.substring(0, 2));
    }

    private static boolean isBrokenConnectionErrorCode(int errorCode) {
        return Arrays.binarySearch(BROKEN_CONNECTION_ERRORS, errorCode) >= 0;
    }

    private static boolean isBrokenConnectionSqlState(String sqlState) {
        return sqlState != null && sqlState.startsWith("08");
    }

    public static boolean isBrokenConnection(Exception exception) {
        if (exception == null) {
            return false;
        }
        SQLException firstSqlException = FatalErrorHelper.findException(exception, SQLException.class);
        if (firstSqlException != null && (FatalErrorHelper.isBrokenConnectionErrorCode(firstSqlException.getErrorCode()) || FatalErrorHelper.isBrokenConnectionSqlState(firstSqlException.getSQLState()))) {
            return true;
        }
        return FatalErrorHelper.findException(exception, SocketTimeoutException.class) != null || FatalErrorHelper.findException(exception, SocketException.class) != null;
    }

    private static <T extends Exception> T findException(Exception root, Class<T> exceptionType) {
        for (Throwable current = root; current != null; current = current.getCause()) {
            if (!exceptionType.isInstance(current)) continue;
            return (T)((Exception)exceptionType.cast(current));
        }
        return null;
    }

    private FatalErrorHelper() {
    }

    static {
        Arrays.sort(FATAL_ERRORS);
        Arrays.sort(BROKEN_CONNECTION_ERRORS);
    }
}

