#pragma once

#include "rapidcheck/Gen.h"

namespace rc {
namespace gen {

/// Generates an STL container containing elements generated by the given
/// generator. For containers that have both keys and values, you need to supply
/// both a key generator and a value generator separately.
template <typename Container, typename... Ts>
Gen<Container> container(Gen<Ts>... gens);

/// Same as `gen::container` but with explicitly requested container size.
template <typename Container, typename... Ts>
Gen<Container> container(std::size_t count, Gen<Ts>... gens);

/// Generates a container of unique `T`.
template <typename Container, typename T>
Gen<Container> unique(Gen<T> gen);

/// Generates a container of `T` such that for every element `e` in the
/// container, `f(e)` is unique.
template <typename Container, typename T, typename F>
Gen<Container> uniqueBy(Gen<T> gen, F &&f);

} // namespace gen
} // namespace rc

#include "Container.hpp"
