\name{IsoContourDistanceImageFilter}
\alias{IsoContourDistanceImageFilter}
\title{IsoContourDistanceImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Compute an approximate distance from an interpolated isocontour to the
close grid points.
IsoContourDistanceImageFilter}
\details{
For standard level set algorithms, it is useful to periodically
reinitialize the evolving image to prevent numerical accuracy problems
in computing derivatives. This reinitialization is done by computing a
signed distance map to the current level set. This class provides the
first step in this reinitialization by computing an estimate of the
distance from the interpolated isocontour to the pixels (or voxels)
that are close to it, i.e. for which the isocontour crosses a segment
between them and one of their direct neighbors. This class supports
narrowbanding. If the input narrowband is provided, the algorithm will
only locate the level set within the input narrowband.
Implementation of this class is based on Fast and Accurate
Redistancing for Level Set Methods Krissian K. and Westin C.F.,
EUROCAST NeuroImaging Workshop Las Palmas Spain, Ninth International
Conference on Computer Aided Systems Theory , pages 48-51, Feb 2003.
See:
IsoContourDistance for the procedural interface
itk::IsoContourDistanceImageFilter for the Doxygen on the original ITK class.
IsoContourDistanceImageFilter}
%C++ includes: sitkIsoContourDistanceImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{double GetFarValue() const:}{
Set/Get the value of the level set to be located. The default value is
0.
}
\item{double GetLevelSetValue() const:}{
Set/Get the value of the level set to be located. The default value is
0.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{ IsoContourDistanceImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetFarValue(double FarValue):}{
Set/Get the value of the level set to be located. The default value is
0.
}
\item{Self SetLevelSetValue(double LevelSetValue):}{
Set/Get the value of the level set to be located. The default value is
0.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~IsoContourDistanceImageFilter():}{
Destructor
}
}
}
