/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.event;

import java.awt.event.InputEvent;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.event.AWTEventDispatcher;
import org.apache.batik.gvt.event.GraphicsNodeEvent;

public abstract class GraphicsNodeInputEvent
extends GraphicsNodeEvent {
    public static final int SHIFT_MASK = 1;
    public static final int CTRL_MASK = 2;
    public static final int META_MASK = 4;
    public static final int ALT_MASK = 8;
    public static final int ALT_GRAPH_MASK = 32;
    public static final int BUTTON1_MASK = 1024;
    public static final int BUTTON2_MASK = 2048;
    public static final int BUTTON3_MASK = 4096;
    public static final int CAPS_LOCK_MASK = 1;
    public static final int NUM_LOCK_MASK = 2;
    public static final int SCROLL_LOCK_MASK = 4;
    public static final int KANA_LOCK_MASK = 8;
    long when;
    int modifiers;
    int lockState;

    protected GraphicsNodeInputEvent(GraphicsNode graphicsNode, int n, long l, int n2, int n3) {
        super(graphicsNode, n);
        this.when = l;
        this.modifiers = n2;
        this.lockState = n3;
    }

    protected GraphicsNodeInputEvent(GraphicsNode graphicsNode, InputEvent inputEvent, int n) {
        super(graphicsNode, inputEvent.getID());
        this.when = inputEvent.getWhen();
        this.modifiers = inputEvent.getModifiers();
        this.lockState = n;
    }

    public boolean isShiftDown() {
        return (this.modifiers & 1) != 0;
    }

    public boolean isControlDown() {
        return (this.modifiers & 2) != 0;
    }

    public boolean isMetaDown() {
        return AWTEventDispatcher.isMetaDown(this.modifiers);
    }

    public boolean isAltDown() {
        return (this.modifiers & 8) != 0;
    }

    public boolean isAltGraphDown() {
        return (this.modifiers & 0x20) != 0;
    }

    public long getWhen() {
        return this.when;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public int getLockState() {
        return this.lockState;
    }
}

