/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.model;

import com.amazonaws.encryptionsdk.exception.AwsCryptoException;
import com.amazonaws.encryptionsdk.exception.BadCiphertextException;
import com.amazonaws.encryptionsdk.exception.ParseException;
import com.amazonaws.encryptionsdk.internal.PrimitivesParser;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class CipherBlockHeaders {
    private byte[] nonce_;
    private long contentLength_ = -1L;
    private short nonceLength_ = 0;
    private boolean isComplete_;

    public CipherBlockHeaders() {
    }

    public CipherBlockHeaders(byte[] nonce, long contentLen) {
        if (nonce == null) {
            throw new AwsCryptoException("Nonce cannot be null.");
        }
        if (nonce.length > 255) {
            throw new AwsCryptoException("Nonce length is greater than the maximum value of an unsigned byte.");
        }
        this.nonce_ = (byte[])nonce.clone();
        this.contentLength_ = contentLen;
    }

    public byte[] toByteArray() {
        int outLen = this.nonce_.length + 8;
        ByteBuffer out = ByteBuffer.allocate(outLen);
        out.put(this.nonce_);
        out.putLong(this.contentLength_);
        return out.array();
    }

    private int parseNonce(byte[] b, int off) throws ParseException {
        int bytesToParseLen = b.length - off;
        if (bytesToParseLen >= this.nonceLength_) {
            this.nonce_ = Arrays.copyOfRange(b, off, off + this.nonceLength_);
            return this.nonceLength_;
        }
        throw new ParseException("Not enough bytes to parse nonce");
    }

    private int parseContentLength(byte[] b, int off) throws ParseException {
        this.contentLength_ = PrimitivesParser.parseLong(b, off);
        if (this.contentLength_ < 0L) {
            throw new BadCiphertextException("Invalid content length in ciphertext");
        }
        return 8;
    }

    public int deserialize(byte[] b, int off) {
        if (b == null) {
            return 0;
        }
        int parsedBytes = 0;
        try {
            if (this.nonceLength_ > 0 && this.nonce_ == null) {
                parsedBytes += this.parseNonce(b, off + parsedBytes);
            }
            if (this.contentLength_ < 0L) {
                parsedBytes += this.parseContentLength(b, off + parsedBytes);
            }
            this.isComplete_ = true;
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return parsedBytes;
    }

    public boolean isComplete() {
        return this.isComplete_;
    }

    public byte[] getNonce() {
        return this.nonce_ != null ? (byte[])this.nonce_.clone() : null;
    }

    public long getContentLength() {
        return this.contentLength_;
    }

    public void setNonceLength(short nonceLength) {
        this.nonceLength_ = nonceLength;
    }
}

