/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jobscheduler.repackage.com.cronutils.model.field.expression;

import java.util.List;
import org.opensearch.jobscheduler.repackage.com.cronutils.model.field.expression.Always;
import org.opensearch.jobscheduler.repackage.com.cronutils.model.field.expression.And;
import org.opensearch.jobscheduler.repackage.com.cronutils.model.field.expression.Between;
import org.opensearch.jobscheduler.repackage.com.cronutils.model.field.expression.Every;
import org.opensearch.jobscheduler.repackage.com.cronutils.model.field.expression.FieldExpression;
import org.opensearch.jobscheduler.repackage.com.cronutils.model.field.expression.On;
import org.opensearch.jobscheduler.repackage.com.cronutils.model.field.expression.QuestionMark;
import org.opensearch.jobscheduler.repackage.com.cronutils.model.field.value.IntegerFieldValue;
import org.opensearch.jobscheduler.repackage.com.cronutils.model.field.value.SpecialChar;
import org.opensearch.jobscheduler.repackage.com.cronutils.model.field.value.SpecialCharFieldValue;
import org.opensearch.jobscheduler.repackage.com.cronutils.utils.Preconditions;

public class FieldExpressionFactory {
    private FieldExpressionFactory() {
    }

    public static Always always() {
        return Always.INSTANCE;
    }

    public static Between between(int from, int to) {
        return new Between(new IntegerFieldValue(from), new IntegerFieldValue(to));
    }

    public static Between between(SpecialChar from, int to) {
        return new Between(new SpecialCharFieldValue(from), new IntegerFieldValue(to));
    }

    public static Every every(int time) {
        return new Every(new IntegerFieldValue(time));
    }

    public static Every every(FieldExpression expression, int time) {
        return new Every(expression, new IntegerFieldValue(time));
    }

    public static On on(SpecialChar specialChar) {
        return new On(new SpecialCharFieldValue(specialChar));
    }

    public static On on(int time) {
        Preconditions.checkPositive(time, "Time must not be negative");
        return new On(new IntegerFieldValue(time));
    }

    public static On on(int time, SpecialChar specialChar) {
        return new On(new IntegerFieldValue(time), new SpecialCharFieldValue(specialChar));
    }

    public static On on(int time, SpecialChar specialChar, int nth) {
        return new On(new IntegerFieldValue(time), new SpecialCharFieldValue(specialChar), new IntegerFieldValue(nth));
    }

    public static QuestionMark questionMark() {
        return QuestionMark.INSTANCE;
    }

    public static And and(List<FieldExpression> expressions) {
        And and = new And();
        for (FieldExpression expression : expressions) {
            and.and(expression);
        }
        return and;
    }
}

