/*
 * Decompiled with CFR 0.152.
 */
package oracle.rsi.internal;

import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import oracle.rsi.RSIException;
import oracle.rsi.internal.AbstractIngester;

class FlowSubscriber<T>
implements Flow.Subscriber<T> {
    private boolean isSubscribed = false;
    private boolean isComplete = false;
    private final AbstractIngester rsi;
    private Flow.Subscription activeSubscription;
    private final AtomicBoolean isStalled = new AtomicBoolean(false);

    FlowSubscriber(AbstractIngester abstractIngester) {
        this.rsi = abstractIngester;
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        if (this.isSubscribed) {
            String string = "A Subscriber can subscribe to only one publisher.";
            throw new RSIException(string);
        }
        if (this.activeSubscription == null) {
            this.isSubscribed = true;
            this.activeSubscription = subscription;
            this.rsi.register(this);
            long l = this.rsi.getNextDemand();
            if (l > 0L) {
                this.activeSubscription.request(l);
            } else {
                this.isStalled.compareAndSet(false, true);
            }
            return;
        }
        if (!this.activeSubscription.equals(subscription)) {
            subscription.cancel();
        }
    }

    @Override
    public void onNext(T t) {
        if (this.isComplete) {
            String string = "Subscriber is Closed.";
            throw new RSIException(string);
        }
        this.rsi.putRecord(t);
        long l = this.rsi.getNextDemand();
        if (l > 0L) {
            this.activeSubscription.request(l);
        } else {
            this.isStalled.compareAndSet(false, true);
        }
    }

    @Override
    public void onError(Throwable throwable) {
        throw new RSIException(throwable.getMessage());
    }

    @Override
    public void onComplete() {
        if (!this.isComplete) {
            this.isComplete = true;
        }
    }

    void resume() {
        long l;
        if (this.isComplete) {
            return;
        }
        if (this.isStalled.compareAndSet(true, false) && (l = this.rsi.getNextDemand()) > 0L) {
            this.activeSubscription.request(l);
        }
    }
}

