/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.ssl;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.security.KeyStore;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import oracle.security.pki.ssl.ClassServer;

public class ClassFileServerjks
extends ClassServer {
    private String a;
    private static int b = 2001;
    private int c = 1;
    private static String d = "JKS";
    private static String e = "jks";
    private int f = 0;

    public ClassFileServerjks(ServerSocket serverSocket, String string) throws IOException {
        super(serverSocket);
        this.a = string;
    }

    @Override
    public byte[] getBytes(String string) throws IOException {
        System.out.println("reading: " + string);
        File file = new File(this.a + File.separator + string);
        int n = (int)file.length();
        if (n == 0) {
            throw new IOException("File length is zero: " + string);
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        DataInputStream dataInputStream = new DataInputStream(fileInputStream);
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        return byArray;
    }

    public static void main(String[] stringArray) {
        System.out.println("USAGE: java ClassFileServer port docroot [TLS [true]]");
        System.out.println("");
        System.out.println("If the third argument is TLS, it will start as\na TLS/SSL file server, otherwise, it will be\nan ordinary file server. \nIf the fourth argument is true,it will require\nclient authentication as well.");
        int n = b;
        String string = "";
        if (stringArray.length >= 1) {
            n = Integer.parseInt(stringArray[0]);
        }
        if (stringArray.length >= 2) {
            string = stringArray[1];
        }
        String string2 = "PlainSocket";
        if (stringArray.length >= 3) {
            string2 = stringArray[2];
        }
        try {
            ServerSocketFactory serverSocketFactory = ClassFileServerjks.a(string2);
            ServerSocket serverSocket = serverSocketFactory.createServerSocket(n);
            if (serverSocket instanceof SSLServerSocket) {
                ((SSLServerSocket)serverSocket).setEnabledProtocols(new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"});
            }
            if (stringArray.length >= 4 && stringArray[3].equals("true")) {
                ((SSLServerSocket)serverSocket).setNeedClientAuth(true);
            }
            ClassFileServerjks classFileServerjks = new ClassFileServerjks(serverSocket, string);
            classFileServerjks.start();
            classFileServerjks.waitForCompletion();
        }
        catch (IOException iOException) {
            System.out.println("Unable to start ClassServer: " + iOException.getMessage());
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            System.out.println(" Error to start ClassServer: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    @Override
    protected synchronized void a() {
        if (this.c > 0) {
            ++this.f;
            --this.c;
            super.a();
        }
    }

    @Override
    public void run() {
        super.run();
        this.b();
    }

    private synchronized void b() {
        --this.f;
        this.notifyAll();
    }

    public synchronized void waitForCompletion() {
        while (this.f > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static TrustManager[] setupTrustManager(String string) throws Exception {
        KeyStore keyStore = null;
        keyStore = KeyStore.getInstance(string);
        FileInputStream fileInputStream = new FileInputStream(System.getProperty("javax.net.ssl.trustStore"));
        keyStore.load(fileInputStream, System.getProperty("javax.net.ssl.trustStorePassword", "").toCharArray());
        String string2 = System.getProperty("test.trustmanager.algorithm", TrustManagerFactory.getDefaultAlgorithm());
        System.out.println("  Using TrustManagerFactory = " + string2);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(string2);
        trustManagerFactory.init(keyStore);
        return trustManagerFactory.getTrustManagers();
    }

    public static KeyManager[] setupKeyManager(String string) throws Exception {
        KeyManager[] keyManagerArray = null;
        if (System.getProperty("javax.net.ssl.keyStore") != null) {
            KeyStore keyStore = null;
            keyStore = string.equals("JKS") ? KeyStore.getInstance(string) : KeyStore.getInstance(string, "OraclePKI");
            FileInputStream fileInputStream = new FileInputStream(System.getProperty("javax.net.ssl.keyStore"));
            keyStore.load(fileInputStream, System.getProperty("javax.net.ssl.keyStorePassword", "").toCharArray());
            String string2 = System.getProperty("test.keymanager.algorithm", KeyManagerFactory.getDefaultAlgorithm());
            System.out.println("  Using KeyManagerFactory   = " + string2);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(string2);
            keyManagerFactory.init(keyStore, System.getProperty("javax.net.ssl.keyStorePassword", "").toCharArray());
            keyManagerArray = keyManagerFactory.getKeyManagers();
        }
        return keyManagerArray;
    }

    private static ServerSocketFactory a(String string) {
        String string2 = "JKS";
        if (string.equals("TLS")) {
            SSLServerSocketFactory sSLServerSocketFactory = null;
            try {
                SSLContext sSLContext = SSLContext.getInstance("TLS");
                TrustManager[] trustManagerArray = ClassFileServerjks.setupTrustManager(string2);
                KeyManager[] keyManagerArray = ClassFileServerjks.setupKeyManager(string2);
                sSLContext.init(keyManagerArray, trustManagerArray, null);
                sSLServerSocketFactory = sSLContext.getServerSocketFactory();
                return sSLServerSocketFactory;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            return ServerSocketFactory.getDefault();
        }
        return null;
    }
}

