/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.EventListener;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import oracle.jdbc.NotificationRegistration;
import oracle.jdbc.aq.AQNotificationEvent;
import oracle.jdbc.aq.AQNotificationListener;
import oracle.jdbc.dcn.DatabaseChangeListener;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.NTFAQEvent;
import oracle.jdbc.driver.NTFDCNEvent;
import oracle.jdbc.driver.NTFEventListener;
import oracle.jdbc.driver.NTFJMSEvent;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.JMSNotificationListener;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;

abstract class NTFRegistration
implements Monitor,
Diagnosable {
    private static final String CLASS_NAME = NTFRegistration.class.getName();
    private final boolean jdbcGetsNotification;
    private final String clientHost;
    private final int clientTCPPort;
    private final Properties options;
    private final boolean isPurgeOnNTF;
    private final String username;
    private final int namespace;
    private final int jdbcRegId;
    private final String dbName;
    private final short databaseVersion;
    private NotificationRegistration.RegistrationState state;
    private NTFEventListener[] listeners = new NTFEventListener[0];
    private NTFEventListener notificationExceptionListener;
    private final Exception[] connectionCreationExceptionArr;
    private final Monitor.CloseableLock monitorLock = Monitor.newDefaultLock();

    NTFRegistration(int _jdbcRegId, int _namespace, boolean _jdbcGetsNotification, String _dbName, String _clientHost, int _clientTCPPort, @Blind(value=PropertiesBlinder.class) Properties _options, String _username, short _databaseVersion, Exception[] _connectionCreationExceptionArr) {
        this.namespace = _namespace;
        this.clientHost = _clientHost;
        this.clientTCPPort = _clientTCPPort;
        this.options = _options;
        this.jdbcRegId = _jdbcRegId;
        this.username = _username;
        this.jdbcGetsNotification = _jdbcGetsNotification;
        this.dbName = _dbName;
        this.state = NotificationRegistration.RegistrationState.ACTIVE;
        this.isPurgeOnNTF = this.options != null && this.options.getProperty("NTF_QOS_PURGE_ON_NTFN", "false").compareToIgnoreCase("true") == 0;
        this.databaseVersion = _databaseVersion;
        this.connectionCreationExceptionArr = _connectionCreationExceptionArr;
    }

    short getDatabaseVersion() {
        return this.databaseVersion;
    }

    void setNotificationExceptionListener(NTFEventListener lsnr) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.state == NotificationRegistration.RegistrationState.CLOSED) {
                throw (SQLException)DatabaseError.createSqlException(251).fillInStackTrace();
            }
            this.notificationExceptionListener = lsnr;
        }
    }

    NTFEventListener getNotificationExceptionListener() {
        return this.notificationExceptionListener;
    }

    void addListener(NTFEventListener l) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.state == NotificationRegistration.RegistrationState.CLOSED) {
                throw (SQLException)DatabaseError.createSqlException(251).fillInStackTrace();
            }
            if (!this.jdbcGetsNotification) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 247).fillInStackTrace();
            }
            int length = this.listeners.length;
            for (int i = 0; i < length; ++i) {
                if (this.listeners[i].getListener() != l.getListener()) continue;
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 248).fillInStackTrace();
            }
            NTFEventListener[] listeners2 = new NTFEventListener[length + 1];
            System.arraycopy(this.listeners, 0, listeners2, 0, length);
            listeners2[length] = l;
            this.listeners = listeners2;
            this.debug(Level.CONFIG, SecurityLabel.UNKNOWN, CLASS_NAME, "addListener", null, null, null);
        }
    }

    void removeListener(EventListener l) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            int i = 0;
            int length = this.listeners.length;
            for (i = 0; i < length && this.listeners[i].getListener() != l; ++i) {
            }
            if (i == length) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 249).fillInStackTrace();
            }
            NTFEventListener[] listeners2 = new NTFEventListener[length - 1];
            int offset = 0;
            for (i = 0; i < length; ++i) {
                if (this.listeners[i].getListener() == l) continue;
                listeners2[offset++] = this.listeners[i];
            }
            this.listeners = listeners2;
            this.debug(Level.CONFIG, SecurityLabel.UNKNOWN, CLASS_NAME, "removeListener", null, null, null);
        }
    }

    void notify(final NTFDCNEvent event) {
        long start = 0L;
        NTFEventListener[] localListeners = this.listeners;
        int length = localListeners.length;
        int i = 0;
        while (i < length) {
            Executor exec = localListeners[i].getExecutor();
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "notify", "listener={0}, executor={1}. ", (String)null, (Throwable)null, (Object)localListeners[i], (Object)exec);
            if (exec != null) {
                final DatabaseChangeListener l = localListeners[i].getDCNListener();
                exec.execute(new Runnable(){

                    @Override
                    public void run() {
                        l.onDatabaseChangeNotification(event);
                    }
                });
            } else {
                localListeners[i].getDCNListener().onDatabaseChangeNotification(event);
            }
            long end = System.nanoTime();
            int _i = i++;
            this.debugp(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "notify", "listener={0}, time={1}ms. ", null, null, () -> new Object[]{localListeners[_i], (double)(end - start) / 1000000.0});
            this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "notify", "connection={0}, dbname={1}, eventType={2}, regId={3}. ", (String)null, null, (Object)event.getConnectionInformation(), (Object)event.getDatabaseName(), (Object)event.getEventType().toString(), (Object)event.getRegistrationId());
        }
        if (event.isDeregistrationEvent() || this.isPurgeOnNTF) {
            PhysicalConnection.ntfManager.removeRegistration(this);
            PhysicalConnection.ntfManager.freeJdbcRegId(this.getJdbcRegId());
            PhysicalConnection.ntfManager.cleanListenersT4C(this.getClientTCPPort());
            this.state = NotificationRegistration.RegistrationState.CLOSED;
        }
    }

    void notify(final NTFAQEvent event) {
        long start = 0L;
        NTFEventListener[] localListeners = this.listeners;
        int length = localListeners.length;
        for (int i = 0; i < length; ++i) {
            Executor exec = localListeners[i].getExecutor();
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "notify", "listener={0}, executor={1}. ", (String)null, (Throwable)null, (Object)localListeners[i], (Object)exec);
            if (exec != null) {
                final AQNotificationListener l = localListeners[i].getAQListener();
                exec.execute(new Runnable(){

                    @Override
                    public void run() {
                        l.onAQNotification(event);
                    }
                });
            } else {
                localListeners[i].getAQListener().onAQNotification(event);
            }
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "notify", "listener={0}, time={1}ms. ", (String)null, (Throwable)null, (Object)localListeners[i], (Object)((double)(System.nanoTime() - start) / 1000000.0));
        }
        if (event.getEventType() == AQNotificationEvent.EventType.DEREG || this.isPurgeOnNTF) {
            PhysicalConnection.ntfManager.removeRegistration(this);
            PhysicalConnection.ntfManager.freeJdbcRegId(this.getJdbcRegId());
            PhysicalConnection.ntfManager.cleanListenersT4C(this.getClientTCPPort());
            this.state = NotificationRegistration.RegistrationState.CLOSED;
        }
    }

    void notify(final NTFJMSEvent event) {
        long start = 0L;
        NTFEventListener[] localListeners = this.listeners;
        int length = localListeners.length;
        for (int i = 0; i < length; ++i) {
            Executor exec = localListeners[i].getExecutor();
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "notify", "listener={0}, executor={1}. ", (String)null, (Throwable)null, (Object)localListeners[i], (Object)exec);
            if (exec != null) {
                final JMSNotificationListener l = localListeners[i].getJMSListener();
                exec.execute(new Runnable(){

                    @Override
                    public void run() {
                        l.onJMSNotification(event);
                    }
                });
            } else {
                localListeners[i].getJMSListener().onJMSNotification(event);
            }
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "notify", "listener={0}. time={1}ms. ", (String)null, (Throwable)null, (Object)localListeners[i], (Object)((double)(System.nanoTime() - start) / 1000000.0));
        }
    }

    @Blind(value=PropertiesBlinder.class)
    public Properties getRegistrationOptions() {
        return this.options;
    }

    int getJdbcRegId() {
        return this.jdbcRegId;
    }

    public String getUserName() {
        return this.username;
    }

    String getClientHost() {
        return this.clientHost;
    }

    int getClientTCPPort() {
        return this.clientTCPPort;
    }

    public String getDatabaseName() {
        return this.dbName;
    }

    public NotificationRegistration.RegistrationState getState() {
        return this.state;
    }

    protected void setState(NotificationRegistration.RegistrationState _state) {
        this.state = _state;
    }

    int getNamespace() {
        return this.namespace;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    public Exception getRegistrationException() {
        if (this.connectionCreationExceptionArr != null && this.connectionCreationExceptionArr.length > 0) {
            return this.connectionCreationExceptionArr[0];
        }
        return null;
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }

    @Override
    public Diagnosable getDiagnosable() {
        return CommonDiagnosable.getInstance();
    }
}

