<?php

declare (strict_types=1);
namespace OCA\News\Vendor\FeedIo\Rule\Atom;

use OCA\News\Vendor\FeedIo\Feed\Item;
use OCA\News\Vendor\FeedIo\Feed\Item\MediaInterface;
use OCA\News\Vendor\FeedIo\Feed\ItemInterface;
use OCA\News\Vendor\FeedIo\Feed\NodeInterface;
use OCA\News\Vendor\FeedIo\RuleAbstract;
use OCA\News\Vendor\FeedIo\FeedInterface;
class Logo extends RuleAbstract
{
    // https://tools.ietf.org/html/rfc4287#section-4.2.8
    public const NODE_NAME = 'logo';
    /**
     * @param  NodeInterface $node
     * @param  \DOMElement   $element
     */
    public function setProperty(NodeInterface $node, \DOMElement $element): void
    {
        if ($node instanceof FeedInterface) {
            $node->setLogo($element->nodeValue);
        }
    }
    /**
     * @inheritDoc
     */
    protected function hasValue(NodeInterface $node): bool
    {
        return $node instanceof FeedInterface && !!$node->getLogo();
    }
    /**
     * @inheritDoc
     */
    protected function addElement(\DomDocument $document, \DOMElement $rootElement, NodeInterface $node): void
    {
        if (!$node instanceof FeedInterface || is_null($node->getLogo())) {
            return;
        }
        $rootElement->appendChild($document->createElement($this->getNodeName(), $node->getLogo()));
    }
}
