/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.swing.JDialog;
import javax.swing.JFrame;
import mediathek.mainwindow.MemoryUsagePanel;
import mediathek.tool.ApplicationConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.sync.LockMode;
import org.jetbrains.annotations.NotNull;

public class MemoryMonitorDialog
extends JDialog {
    public MemoryMonitorDialog(@NotNull JFrame parent) {
        super(parent, "Speicherverbrauch", false);
        this.setType(Window.Type.UTILITY);
        MemoryUsagePanel panel = new MemoryUsagePanel(2, TimeUnit.MINUTES);
        panel.setPreferredSize(new Dimension(480, 240));
        this.getContentPane().add((Component)panel, "Center");
        this.pack();
        MemoryUsagePanel memoryUsagePanel = panel;
        Objects.requireNonNull(memoryUsagePanel);
        new MemoryUsagePanel.MemoryUsageDataGenerator(memoryUsagePanel, 1, TimeUnit.SECONDS).start();
        this.restoreLocation();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MemoryMonitorDialog.this.saveLocation();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                MemoryMonitorDialog.this.saveLocation();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                ApplicationConfiguration.getConfiguration().setProperty("memory_monitor.visible", (Object)true);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                ApplicationConfiguration.getConfiguration().setProperty("memory_monitor.visible", (Object)false);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreLocation() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        config.lock(LockMode.READ);
        try {
            Point newLocation = new Point();
            newLocation.x = config.getInt("memory_monitor.x");
            newLocation.y = config.getInt("memory_monitor.y");
            this.setLocation(newLocation);
            int w = config.getInt("memory_monitor.width", -1);
            int h = config.getInt("memory_monitor.height", -1);
            if (w != -1 && h != -1) {
                this.setPreferredSize(new Dimension(w, h));
            }
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        finally {
            config.unlock(LockMode.READ);
        }
    }

    private void saveLocation() {
        if (!this.isVisible()) {
            return;
        }
        Configuration config = ApplicationConfiguration.getConfiguration();
        try {
            config.lock(LockMode.WRITE);
            Point location = this.getLocationOnScreen();
            config.setProperty("memory_monitor.x", (Object)location.x);
            config.setProperty("memory_monitor.y", (Object)location.y);
            config.setProperty("memory_monitor.width", (Object)this.getWidth());
            config.setProperty("memory_monitor.height", (Object)this.getHeight());
        }
        finally {
            config.unlock(LockMode.WRITE);
        }
    }
}

