/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.actions;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.AbstractAction;
import mediathek.gui.actions.UrlHyperlinkAction;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.SVGIconUtilities;
import mediathek.tool.SwingErrorDialog;

public class ShowOnlineHelpAction
extends AbstractAction {
    public ShowOnlineHelpAction() {
        this.putValue("Name", "Online-Hilfe anzeigen...");
        this.putValue("SmallIcon", SVGIconUtilities.createSVGIcon("icons/fontawesome/circle-question.svg"));
    }

    private void openUrl() {
        UrlHyperlinkAction.openURL("https://mediathekview.de/anleitung/");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (Desktop.isDesktopSupported()) {
            Desktop d = Desktop.getDesktop();
            if (d.isSupported(Desktop.Action.BROWSE)) {
                try {
                    d.browse(new URI("https://mediathekview.de/anleitung/"));
                }
                catch (IOException | URISyntaxException ex) {
                    SwingErrorDialog.showExceptionMessage(MediathekGui.ui(), "Es trat ein Fehler beim \u00d6ffnen der Online-Hilfe auf.\nSollte dies h\u00e4ufiger auftreten kontaktieren Sie bitte das Entwicklerteam.", ex);
                }
            } else {
                this.openUrl();
            }
        } else {
            this.openUrl();
        }
    }
}

