/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect.function.json;

import java.util.List;
import org.hibernate.dialect.function.json.JsonObjectFunction;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JsonNullBehavior;
import org.hibernate.type.spi.TypeConfiguration;

public class GaussDBJsonObjectFunction
extends JsonObjectFunction {
    public GaussDBJsonObjectFunction(TypeConfiguration typeConfiguration) {
        super(typeConfiguration, false);
    }

    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql("json_build_object");
        char separator = '(';
        if (sqlAstArguments.isEmpty()) {
            sqlAppender.appendSql(separator);
        } else {
            int argumentsCount;
            JsonNullBehavior nullBehavior;
            if ((sqlAstArguments.size() & 1) == 1) {
                nullBehavior = (JsonNullBehavior)sqlAstArguments.get(sqlAstArguments.size() - 1);
                argumentsCount = sqlAstArguments.size() - 1;
            } else {
                nullBehavior = JsonNullBehavior.NULL;
                argumentsCount = sqlAstArguments.size();
            }
            sqlAppender.appendSql('(');
            separator = ' ';
            for (int i = 0; i < argumentsCount; i += 2) {
                SqlAstNode key = sqlAstArguments.get(i);
                Expression valueNode = (Expression)sqlAstArguments.get(i + 1);
                if (nullBehavior == JsonNullBehavior.ABSENT && walker.getLiteralValue(valueNode) == null) continue;
                if (separator != ' ') {
                    sqlAppender.appendSql(separator);
                } else {
                    separator = ',';
                }
                key.accept(walker);
                sqlAppender.appendSql(',');
                valueNode.accept(walker);
            }
        }
        sqlAppender.appendSql(')');
    }
}

