/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.grants.ciba.channel;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import javax.crypto.SecretKey;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.jose.jwe.JWEException;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.services.Urls;
import org.keycloak.util.TokenUtil;

public class CIBAAuthenticationRequest
extends JsonWebToken {
    public static final String SESSION_STATE = "session_state";
    public static final String AUTH_RESULT_ID = "auth_result_id";
    @JsonProperty(value="scope")
    protected String scope;
    @JsonProperty(value="auth_result_id")
    protected String authResultId;
    @JsonProperty(value="binding_message")
    protected String bindingMessage;
    @JsonProperty(value="acr_values")
    protected String acrValues;
    @JsonIgnore
    protected ClientModel client;
    @JsonIgnore
    protected String clientNotificationToken;
    @JsonIgnore
    protected UserModel user;

    public static CIBAAuthenticationRequest deserialize(KeycloakSession session, String jwe) {
        SecretKey aesKey = session.keys().getActiveKey(session.getContext().getRealm(), KeyUse.ENC, "AES").getSecretKey();
        SecretKey hmacKey = session.keys().getActiveKey(session.getContext().getRealm(), KeyUse.SIG, "HS512").getSecretKey();
        try {
            byte[] contentBytes = TokenUtil.jweDirectVerifyAndDecode((Key)aesKey, (Key)hmacKey, (String)jwe);
            jwe = new String(contentBytes, StandardCharsets.UTF_8);
        }
        catch (JWEException e) {
            throw new RuntimeException("Error decoding auth_req_id.", e);
        }
        return (CIBAAuthenticationRequest)session.tokens().decode(jwe, CIBAAuthenticationRequest.class);
    }

    public CIBAAuthenticationRequest() {
    }

    public CIBAAuthenticationRequest(KeycloakSession session, UserModel user, ClientModel client) {
        this.id(KeycloakModelUtils.generateId());
        this.issuedNow();
        RealmModel realm = session.getContext().getRealm();
        this.issuer(Urls.realmIssuer(session.getContext().getUri().getBaseUri(), realm.getName()));
        this.audience(new String[]{this.getIssuer()});
        this.subject(user.getId());
        this.issuedFor(client.getClientId());
        this.setAuthResultId(KeycloakModelUtils.generateId());
        this.setClient(client);
        this.setUser(user);
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getAuthResultId() {
        return this.authResultId;
    }

    public void setAuthResultId(String authResultId) {
        this.authResultId = authResultId;
    }

    public String getBindingMessage() {
        return this.bindingMessage;
    }

    public void setBindingMessage(String binding_message) {
        this.bindingMessage = binding_message;
    }

    public String getAcrValues() {
        return this.acrValues;
    }

    public void setAcrValues(String acrValues) {
        this.acrValues = acrValues;
    }

    public String serialize(KeycloakSession session) {
        try {
            SignatureProvider signatureProvider = (SignatureProvider)session.getProvider(SignatureProvider.class, "HS512");
            SignatureSignerContext signer = signatureProvider.signer();
            String encodedJwt = new JWSBuilder().type("JWT").jsonContent((Object)this).sign(signer);
            SecretKey aesKey = session.keys().getActiveKey(session.getContext().getRealm(), KeyUse.ENC, "AES").getSecretKey();
            SecretKey hmacKey = session.keys().getActiveKey(session.getContext().getRealm(), KeyUse.SIG, "HS512").getSecretKey();
            return TokenUtil.jweDirectEncode((Key)aesKey, (Key)hmacKey, (byte[])encodedJwt.getBytes(StandardCharsets.UTF_8));
        }
        catch (JWEException e) {
            throw new RuntimeException("Error encoding auth_req_id.", e);
        }
    }

    public void setClient(ClientModel client) {
        this.client = client;
    }

    public ClientModel getClient() {
        return this.client;
    }

    public String getClientNotificationToken() {
        return this.clientNotificationToken;
    }

    public void setClientNotificationToken(String clientNotificationToken) {
        this.clientNotificationToken = clientNotificationToken;
    }

    public void setUser(UserModel user) {
        this.user = user;
    }

    public UserModel getUser() {
        return this.user;
    }
}

