/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories.impl;

import org.infinispan.factories.impl.BasicComponentRegistryImpl;
import org.infinispan.factories.impl.ComponentRef;

public class WireContext {
    private final BasicComponentRegistryImpl registry;

    WireContext(BasicComponentRegistryImpl registry) {
        this.registry = registry;
    }

    public <T> T get(String componentName, Class<T> componentClass, boolean start) {
        ComponentRef componentRef = this.registry.getComponent0(componentName, componentClass, true);
        if (componentRef == null) {
            return this.registry.throwDependencyNotFound(componentName);
        }
        return start ? componentRef.running() : componentRef.wired();
    }

    public <T, U extends T> ComponentRef<T> getLazy(String componentName, Class<U> componentClass, boolean start) {
        ComponentRef componentRef = this.registry.getComponent0(componentName, componentClass, false);
        if (componentRef == null) {
            this.registry.throwDependencyNotFound(componentName);
        }
        return componentRef;
    }
}

