/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import javax.swing.ImageIcon;
import net.sf.juife.wizard.DefaultWizardModel;
import net.sf.juife.wizard.WizardPage;
import org.jsampler.CC;
import org.jsampler.MidiInstrumentMap;
import org.jsampler.OrchestraInstrument;
import org.jsampler.view.std.InstrLocationMethodWizardPage;
import org.jsampler.view.std.InstrumentMappingWizardPage;
import org.jsampler.view.std.ManualSelectWizardPage;
import org.jsampler.view.std.OrchestraSelectWizardPage;
import org.jsampler.view.std.StdI18n;
import org.linuxsampler.lscp.MidiInstrumentInfo;

class NewMidiInstrumentWizardModel
extends DefaultWizardModel {
    private final InstrLocationMethodWizardPage instrLocationMethodWizardPage;
    private final OrchestraSelectWizardPage orchestraSelectWizardPage;
    private final ManualSelectWizardPage manualSelectWizardPage;
    private final InstrumentMappingWizardPage instrumentMappingWizardPage;
    private MidiInstrumentMap defaultMap;

    NewMidiInstrumentWizardModel(ImageIcon imageIcon, MidiInstrumentMap midiInstrumentMap) {
        this.defaultMap = midiInstrumentMap;
        this.instrLocationMethodWizardPage = new InstrLocationMethodWizardPage();
        this.orchestraSelectWizardPage = new OrchestraSelectWizardPage();
        this.manualSelectWizardPage = new ManualSelectWizardPage(imageIcon);
        this.instrumentMappingWizardPage = new InstrumentMappingWizardPage(this);
        this.addPage(this.instrLocationMethodWizardPage);
        this.addStep(StdI18n.i18n.getLabel("JSNewMidiInstrumentWizard.step1"));
        this.addPage(this.manualSelectWizardPage);
        this.addPage(this.orchestraSelectWizardPage);
        this.addStep(StdI18n.i18n.getLabel("JSNewMidiInstrumentWizard.step2"), 2);
        this.addPage(this.instrumentMappingWizardPage);
        this.addStep(StdI18n.i18n.getLabel("JSNewMidiInstrumentWizard.step3"));
    }

    public String getInstrumentName() {
        if (!this.instrLocationMethodWizardPage.isOrchestraMethodSelected()) {
            return this.manualSelectWizardPage.getInstrumentName();
        }
        OrchestraInstrument orchestraInstrument = this.orchestraSelectWizardPage.getInstrument();
        if (orchestraInstrument == null) {
            return null;
        }
        return orchestraInstrument.getName();
    }

    @Override
    public WizardPage next() {
        InstrLocationMethodWizardPage instrLocationMethodWizardPage = this.instrLocationMethodWizardPage;
        ManualSelectWizardPage manualSelectWizardPage = this.manualSelectWizardPage;
        if (this.getCurrentPage() == instrLocationMethodWizardPage && instrLocationMethodWizardPage.isOrchestraMethodSelected()) {
            super.next();
        } else if (this.getCurrentPage() == this.manualSelectWizardPage) {
            super.next();
        }
        return super.next();
    }

    @Override
    public WizardPage previous() {
        InstrLocationMethodWizardPage instrLocationMethodWizardPage = this.instrLocationMethodWizardPage;
        InstrumentMappingWizardPage instrumentMappingWizardPage = this.instrumentMappingWizardPage;
        if (this.getCurrentPage() == this.orchestraSelectWizardPage) {
            super.previous();
        } else if (this.getCurrentPage() == instrumentMappingWizardPage && !instrLocationMethodWizardPage.isOrchestraMethodSelected()) {
            super.previous();
        }
        return super.previous();
    }

    public void mapInstrument() {
        MidiInstrumentInfo midiInstrumentInfo = new MidiInstrumentInfo();
        if (this.instrLocationMethodWizardPage.isOrchestraMethodSelected()) {
            OrchestraInstrument orchestraInstrument = this.orchestraSelectWizardPage.getInstrument();
            midiInstrumentInfo.setFilePath(orchestraInstrument.getFilePath());
            midiInstrumentInfo.setInstrumentIndex(orchestraInstrument.getInstrumentIndex());
            midiInstrumentInfo.setEngine(orchestraInstrument.getEngine());
            midiInstrumentInfo.setLoadMode(this.orchestraSelectWizardPage.getLoadMode());
        } else {
            midiInstrumentInfo.setFilePath(this.manualSelectWizardPage.getSelectedFile());
            midiInstrumentInfo.setInstrumentIndex(this.manualSelectWizardPage.getInstrumentIndex());
            midiInstrumentInfo.setEngine(this.manualSelectWizardPage.getEngine());
            midiInstrumentInfo.setLoadMode(this.manualSelectWizardPage.getLoadMode());
        }
        int n = this.instrumentMappingWizardPage.getMapId();
        int n2 = this.instrumentMappingWizardPage.getMidiBank();
        int n3 = this.instrumentMappingWizardPage.getMidiProgram();
        midiInstrumentInfo.setName(this.instrumentMappingWizardPage.getInstrumentName());
        midiInstrumentInfo.setVolume(this.instrumentMappingWizardPage.getVolume());
        CC.getSamplerModel().mapBackendMidiInstrument(n, n2, n3, midiInstrumentInfo);
    }

    public MidiInstrumentMap getDefaultMap() {
        return this.defaultMap;
    }

    public void setDefaultMap(MidiInstrumentMap midiInstrumentMap) {
        this.defaultMap = midiInstrumentMap;
    }
}

