/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import net.sf.juife.event.TaskEvent;
import net.sf.juife.event.TaskListener;
import org.jsampler.AudioDeviceModel;
import org.jsampler.CC;
import org.jsampler.JSPrefs;
import org.jsampler.SamplerChannelModel;
import org.jsampler.event.EffectSendsAdapter;
import org.jsampler.event.EffectSendsEvent;
import org.jsampler.event.EffectSendsListener;
import org.jsampler.task.Channel;
import org.jsampler.view.FxSendTable;
import org.jsampler.view.std.StdI18n;
import org.jsampler.view.std.StdUtils;
import org.linuxsampler.lscp.FxSend;

public class JSFxSendsPane
extends JPanel
implements ListSelectionListener {
    private SamplerChannelModel channelModel;
    private final FxSendTable fxSendsTable;
    protected final Action actionAddFxSend = new AddFxSendAction();
    protected final Action actionRemoveFxSend = new RemoveFxSendAction();
    private final JComboBox cbMidiCtrls = new JComboBox();
    private final JSlider slVolume = StdUtils.createVolumeSlider();
    private final JLabel lMidiCtrl = new JLabel(StdI18n.i18n.getLabel("JSFxSendsPane.lMidiCtrl"));
    private final JLabel lVolume = new JLabel(StdI18n.i18n.getLabel("JSFxSendsPane.lVolume"));
    private final ChannelRoutingTable channelRoutingTable;
    private FxSend fxSend = null;
    private final int[] undefinedControllers = new int[]{3, 9, 14, 15, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 85, 86, 87, 88, 89, 90, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119};
    private int lastUsedController = 0;
    private final Handler eventHandler = new Handler();

    public JSFxSendsPane(SamplerChannelModel samplerChannelModel) {
        if (samplerChannelModel == null) {
            throw new IllegalArgumentException("model should be non-null!");
        }
        this.channelModel = samplerChannelModel;
        this.fxSendsTable = new FxSendTable(this.channelModel);
        this.channelRoutingTable = new ChannelRoutingTable();
        this.setLayout(new BorderLayout());
        JPanel jPanel = this.createRightPane();
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setLeftComponent(this.createLeftPane());
        jSplitPane.setRightComponent(jPanel);
        jSplitPane.setContinuousLayout(true);
        this.add(jSplitPane);
        this.channelModel.addEffectSendsListener(this.getHandler());
        this.fxSendsTable.getSelectionModel().addListSelectionListener(this);
        if (this.channelModel.getChannelInfo().getEngine() == null) {
            this.actionAddFxSend.setEnabled(false);
        }
        if (this.channelModel.getFxSendCount() == 0) {
            this.actionRemoveFxSend.setEnabled(false);
        } else {
            this.fxSendsTable.setSelectedFxSend(this.channelModel.getFxSend(0));
        }
        this.updateFxSend();
        Dimension dimension = this.getMinimumSize();
        int n = dimension.width > 600 ? dimension.width : 600;
        int n2 = dimension.height > 300 ? dimension.height : 300;
        this.setPreferredSize(new Dimension(n, n2));
        jSplitPane.setDividerLocation(200);
    }

    protected JSPrefs preferences() {
        return CC.getViewConfig().preferences();
    }

    public SamplerChannelModel getChannelModel() {
        return this.channelModel;
    }

    protected JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setMaximumSize(new Dimension(Short.MAX_VALUE, jToolBar.getPreferredSize().height));
        jToolBar.setFloatable(false);
        jToolBar.setAlignmentX(1.0f);
        jToolBar.add(new JButton(this.actionAddFxSend));
        jToolBar.add(new JButton(this.actionRemoveFxSend));
        return jToolBar;
    }

    protected JPanel createLeftPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.createToolBar(), "North");
        jPanel.add(new JScrollPane(this.fxSendsTable));
        return jPanel;
    }

    protected JPanel createRightPane() {
        Object object;
        for (int i = 0; i < 128; ++i) {
            object = "[" + i + "] " + this.getMidiControllerName(i);
            this.cbMidiCtrls.addItem(object);
        }
        this.cbMidiCtrls.setMinimumSize(new Dimension(100, this.cbMidiCtrls.getMinimumSize().height));
        this.cbMidiCtrls.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (JSFxSendsPane.this.fxSend == null) {
                    return;
                }
                int n = JSFxSendsPane.this.fxSend.getFxSendId();
                int n2 = JSFxSendsPane.this.cbMidiCtrls.getSelectedIndex();
                if (n2 == JSFxSendsPane.this.fxSend.getMidiController()) {
                    return;
                }
                JSFxSendsPane.this.lastUsedController = n2;
                JSFxSendsPane.this.channelModel.setBackendFxSendMidiController(n, n2);
            }
        });
        this.slVolume.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JSFxSendsPane.this.setVolume();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        object = new JPanel();
        ((Container)object).setLayout(new BoxLayout((Container)object, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.lVolume);
        jPanel2.add(Box.createRigidArea(new Dimension(6, 0)));
        this.slVolume.setMinimumSize(this.slVolume.getPreferredSize());
        jPanel2.add(this.slVolume);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ((Container)object).add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.lMidiCtrl);
        jPanel2.add(Box.createRigidArea(new Dimension(6, 0)));
        jPanel2.add(this.cbMidiCtrls);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ((Container)object).add(jPanel2);
        jPanel.add((Component)object, "North");
        jPanel.add(new JScrollPane(this.channelRoutingTable));
        return jPanel;
    }

    private String getMidiControllerName(int n) {
        switch (n) {
            case 0: {
                return "Bank Select";
            }
            case 1: {
                return "Modulation Wheel or Lever";
            }
            case 2: {
                return "Breath Controller";
            }
            case 4: {
                return "Foot Controller";
            }
            case 5: {
                return "Portamento Time";
            }
            case 6: {
                return "Data Entry MSB";
            }
            case 7: {
                return "Channel Volume";
            }
            case 8: {
                return "Balance";
            }
            case 10: {
                return "Pan";
            }
            case 11: {
                return "Expression Controller";
            }
            case 12: {
                return "Effect Control 1";
            }
            case 13: {
                return "Effect Control 2";
            }
            case 16: {
                return "General Purpose Controller 1";
            }
            case 17: {
                return "General Purpose Controller 2";
            }
            case 18: {
                return "General Purpose Controller 3";
            }
            case 19: {
                return "General Purpose Controller 4";
            }
            case 32: {
                return "LSB for Control 0 (Bank Select)";
            }
            case 33: {
                return "LSB for Control 1 (Modulation Wheel or Lever)";
            }
            case 34: {
                return "LSB for Control 2 (Breath Controller)";
            }
            case 35: {
                return "LSB for Control 3 (Undefined)";
            }
            case 36: {
                return "LSB for Control 4 (Foot Controller)";
            }
            case 37: {
                return "LSB for Control 5 (Portamento Time)";
            }
            case 38: {
                return "LSB for Control 6 (Data Entry)";
            }
            case 39: {
                return "LSB for Control 7 (Channel Volume)";
            }
            case 40: {
                return "LSB for Control 8 (Balance)";
            }
            case 41: {
                return "LSB for Control 9 (Undefined)";
            }
            case 42: {
                return "LSB for Control 10 (Pan)";
            }
            case 43: {
                return "LSB for Control 11 (Expression Controller)";
            }
            case 44: {
                return "LSB for Control 12 (Effect control 1)";
            }
            case 45: {
                return "LSB for Control 13 (Effect control 2)";
            }
            case 46: {
                return "LSB for Control 14 (Undefined)";
            }
            case 47: {
                return "LSB for Control 15 (Undefined)";
            }
            case 48: {
                return "LSB for Control 16 (General Purpose Controller 1)";
            }
            case 49: {
                return "LSB for Control 17 (General Purpose Controller 2)";
            }
            case 50: {
                return "LSB for Control 18 (General Purpose Controller 3)";
            }
            case 51: {
                return "LSB for Control 19 (General Purpose Controller 4)";
            }
            case 52: {
                return "LSB for Control 20 (Undefined)";
            }
            case 53: {
                return "LSB for Control 21 (Undefined)";
            }
            case 54: {
                return "LSB for Control 22 (Undefined)";
            }
            case 55: {
                return "LSB for Control 23 (Undefined)";
            }
            case 56: {
                return "LSB for Control 24 (Undefined)";
            }
            case 57: {
                return "LSB for Control 25 (Undefined)";
            }
            case 58: {
                return "LSB for Control 26 (Undefined)";
            }
            case 59: {
                return "LSB for Control 27 (Undefined)";
            }
            case 60: {
                return "LSB for Control 28 (Undefined)";
            }
            case 61: {
                return "LSB for Control 29 (Undefined)";
            }
            case 62: {
                return "LSB for Control 30 (Undefined)";
            }
            case 63: {
                return "LSB for Control 31 (Undefined)";
            }
            case 64: {
                return "Damper Pedal on/off (Sustain)";
            }
            case 65: {
                return "Portamento On/Off";
            }
            case 66: {
                return "Sostenuto On/Off";
            }
            case 67: {
                return "Soft Pedal On/Off";
            }
            case 68: {
                return "Legato Footswitch";
            }
            case 69: {
                return "Hold 2";
            }
            case 70: {
                return "Sound Controller 1 (default: Sound Variation)";
            }
            case 71: {
                return "Sound Controller 2 (default: Timbre/Harmonic Intens.)";
            }
            case 72: {
                return "Sound Controller 3 (default: Release Time)";
            }
            case 73: {
                return "Sound Controller 4 (default: Attack Time)";
            }
            case 74: {
                return "Sound Controller 5 (default: Brightness)";
            }
            case 75: {
                return "Sound Controller 6 (default: Decay Time";
            }
            case 76: {
                return "Sound Controller 7 (default: Vibrato Rate)";
            }
            case 77: {
                return "Sound Controller 8 (default: Vibrato Depth)";
            }
            case 78: {
                return "Sound Controller 9 (default: Vibrato Delay)";
            }
            case 79: {
                return "Sound Controller 10 (default: undefined)";
            }
            case 80: {
                return "General Purpose Controller 5";
            }
            case 81: {
                return "General Purpose Controller 6";
            }
            case 82: {
                return "General Purpose Controller 7";
            }
            case 83: {
                return "General Purpose Controller 8";
            }
            case 84: {
                return "Portamento Control";
            }
            case 91: {
                return "Effects 1 Depth (default: Reverb Send Level)";
            }
            case 92: {
                return "Effects 2 Depth (formerly Tremolo Depth)";
            }
            case 93: {
                return "Effects 3 Depth(default: Chorus Send Level)";
            }
            case 94: {
                return "Effects 4 Depth (formerly Celeste [Detune] Depth)";
            }
            case 95: {
                return "Effects 5 Depth (formerly Phaser Depth)";
            }
            case 96: {
                return "Data Increment (Data Entry +1)";
            }
            case 97: {
                return "Data Decrement (Data Entry -1)";
            }
            case 98: {
                return "Non-Registered Parameter Number (NRPN) - LSB";
            }
            case 99: {
                return "Non-Registered Parameter Number (NRPN) - MSB";
            }
            case 100: {
                return "Registered Parameter Number (RPN) - LSB";
            }
            case 101: {
                return "Registered Parameter Number (RPN) - MSB";
            }
            case 120: {
                return "All Sound Off (Channel Mode Message)";
            }
            case 121: {
                return "Reset All Controllers (Channel Mode Message)";
            }
            case 122: {
                return "Local Control On/Off (Channel Mode Message)";
            }
            case 123: {
                return "All Notes Off (Channel Mode Message)";
            }
            case 124: {
                return "Omni Mode Off (Channel Mode Message)";
            }
            case 125: {
                return "Omni Mode On (Channel Mode Message)";
            }
            case 126: {
                return "Mono Mode On (Channel Mode Message)";
            }
            case 127: {
                return "Poly Mode On (Channel Mode Message)";
            }
        }
        return "Undefined";
    }

    public boolean isUndefinedController(int n) {
        for (int i = 0; i < this.undefinedControllers.length; ++i) {
            if (n != this.undefinedControllers[i]) continue;
            return true;
        }
        return false;
    }

    private int findUndefinedController(int n, Vector<Integer> vector) {
        int n2;
        int n3;
        for (n3 = 0; n3 < this.undefinedControllers.length; ++n3) {
            n2 = this.undefinedControllers[n3];
            if (n2 <= n || vector.contains(n2)) continue;
            return n2;
        }
        for (n3 = 0; n3 < this.undefinedControllers.length && (n2 = this.undefinedControllers[n3]) < n; ++n3) {
            if (vector.contains(n2)) continue;
            return n2;
        }
        return -1;
    }

    public int getUndefinedController() {
        int n;
        int n2 = this.lastUsedController;
        if (n2 > 119) {
            n2 = 0;
        }
        FxSend[] fxSendArray = this.getChannelModel().getFxSends();
        Vector<Integer> vector = new Vector<Integer>();
        for (n = fxSendArray.length - 1; n >= 0; --n) {
            int n3 = fxSendArray[n].getMidiController();
            if (!this.isUndefinedController(n3)) continue;
            vector.add(n3);
        }
        n = this.findUndefinedController(n2, vector);
        return n != -1 ? n : 3;
    }

    private void setVolume() {
        if (this.fxSend == null || this.slVolume.getValueIsAdjusting()) {
            return;
        }
        int n = (int)(this.fxSend.getLevel() * 100.0f);
        if (this.slVolume.getValue() == n) {
            return;
        }
        float f = this.slVolume.getValue();
        this.channelModel.setBackendFxSendLevel(this.fxSend.getFxSendId(), f /= 100.0f);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.fxSend = this.fxSendsTable.getSelectedFxSend();
        this.actionRemoveFxSend.setEnabled(this.fxSend != null);
        this.updateFxSend();
    }

    private void updateFxSend() {
        boolean bl = this.fxSend != null;
        this.cbMidiCtrls.setEnabled(bl);
        this.slVolume.setEnabled(bl);
        this.channelRoutingTable.setEnabled(bl);
        if (!bl) {
            this.slVolume.setValue(0);
            this.cbMidiCtrls.setSelectedIndex(0);
            return;
        }
        this.cbMidiCtrls.setSelectedIndex(this.fxSend.getMidiController());
        this.slVolume.setValue((int)(this.fxSend.getLevel() * 100.0f));
    }

    private Handler getHandler() {
        return this.eventHandler;
    }

    private class Handler
    implements EffectSendsListener {
        private Handler() {
        }

        @Override
        public void effectSendAdded(EffectSendsEvent effectSendsEvent) {
            FxSend fxSend = JSFxSendsPane.this.fxSendsTable.getSelectedFxSend();
            if (fxSend == null) {
                return;
            }
            AddFxSendAction addFxSendAction = (AddFxSendAction)JSFxSendsPane.this.actionAddFxSend;
            if (fxSend.getFxSendId() != addFxSendAction.getFxSendId()) {
                return;
            }
            JSFxSendsPane.this.fxSendsTable.requestFocus();
            JSFxSendsPane.this.fxSendsTable.editSelectedFxSend();
            addFxSendAction.setFxSendId(-1);
        }

        @Override
        public void effectSendRemoved(EffectSendsEvent effectSendsEvent) {
            if (JSFxSendsPane.this.channelModel.getFxSendCount() == 0) {
                return;
            }
            int n = effectSendsEvent.getFxSend().getFxSendId();
            for (FxSend fxSend : JSFxSendsPane.this.channelModel.getFxSends()) {
                if (fxSend.getFxSendId() <= n) continue;
                JSFxSendsPane.this.fxSendsTable.setSelectedFxSend(fxSend);
                return;
            }
            FxSend fxSend = JSFxSendsPane.this.channelModel.getFxSend(JSFxSendsPane.this.channelModel.getFxSendCount() - 1);
            JSFxSendsPane.this.fxSendsTable.setSelectedFxSend(fxSend);
        }

        @Override
        public void effectSendChanged(EffectSendsEvent effectSendsEvent) {
            if (JSFxSendsPane.this.fxSend == null) {
                return;
            }
            if (JSFxSendsPane.this.fxSend.equals(effectSendsEvent.getFxSend())) {
                JSFxSendsPane.this.fxSend = effectSendsEvent.getFxSend();
                JSFxSendsPane.this.updateFxSend();
            }
        }
    }

    class ChannelRoutingTableModel
    extends AbstractTableModel
    implements ListSelectionListener {
        private String[] columnNames = new String[]{StdI18n.i18n.getLabel("JSFxSendsPane.audioSrc"), StdI18n.i18n.getLabel("JSFxSendsPane.audioDst")};

        ChannelRoutingTableModel() {
            JSFxSendsPane.this.channelModel.addEffectSendsListener(new EffectSendsAdapter(){

                @Override
                public void effectSendChanged(EffectSendsEvent effectSendsEvent) {
                    if (JSFxSendsPane.this.fxSend == null) {
                        ChannelRoutingTableModel.this.fireTableDataChanged();
                        return;
                    }
                    if (JSFxSendsPane.this.fxSend.equals(effectSendsEvent.getFxSend())) {
                        int n = effectSendsEvent.getFxSend().getAudioOutputRouting().length;
                        ChannelRoutingTableModel.this.fireTableRowsUpdated(0, n - 1);
                    }
                }
            });
            JSFxSendsPane.this.fxSendsTable.getSelectionModel().addListSelectionListener(this);
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public int getRowCount() {
            if (JSFxSendsPane.this.fxSend == null) {
                return 0;
            }
            return JSFxSendsPane.this.fxSend.getAudioOutputRouting().length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return n;
                }
                case 1: {
                    return JSFxSendsPane.this.fxSend.getAudioOutputRouting()[n];
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            switch (n2) {
                case 0: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                return;
            }
            int n3 = JSFxSendsPane.this.fxSend.getFxSendId();
            int n4 = (Integer)this.getValueAt(n, 0);
            int n5 = (Integer)object;
            JSFxSendsPane.this.channelModel.setBackendFxSendAudioOutputChannel(n3, n4, n5);
            ((JSFxSendsPane)JSFxSendsPane.this).fxSend.getAudioOutputRouting()[n] = n5;
            this.fireTableCellUpdated(n, n2);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            this.fireTableDataChanged();
        }
    }

    class ChannelRoutingTable
    extends JTable {
        private String[] columnToolTips;

        ChannelRoutingTable() {
            super(new ChannelRoutingTableModel());
            this.columnToolTips = new String[]{StdI18n.i18n.getLabel("JSFxSendsPane.ttAudioSrc"), StdI18n.i18n.getLabel("JSFxSendsPane.ttAudioDst")};
            JComboBox<Integer> jComboBox = new JComboBox<Integer>();
            int n = JSFxSendsPane.this.channelModel.getChannelInfo().getAudioOutputDevice();
            AudioDeviceModel audioDeviceModel = CC.getSamplerModel().getAudioDeviceById(n);
            int n2 = audioDeviceModel == null ? JSFxSendsPane.this.channelModel.getChannelInfo().getAudioOutputChannels() : audioDeviceModel.getDeviceInfo().getAudioChannelCount();
            Serializable serializable = Integer.valueOf(0);
            while ((Integer)serializable < n2) {
                jComboBox.addItem((Integer)serializable);
                Integer n3 = serializable;
                serializable = Integer.valueOf((Integer)serializable + 1);
                Integer n4 = serializable;
            }
            serializable = this.getColumnModel().getColumn(1);
            ((TableColumn)serializable).setCellEditor(new DefaultCellEditor(jComboBox));
        }

        @Override
        protected JTableHeader createDefaultTableHeader() {
            return new JTableHeader(this.columnModel){

                @Override
                public String getToolTipText(MouseEvent mouseEvent) {
                    Point point = mouseEvent.getPoint();
                    int n = this.columnModel.getColumnIndexAtX(point.x);
                    n = this.columnModel.getColumn(n).getModelIndex();
                    return ChannelRoutingTable.this.columnToolTips[n];
                }
            };
        }
    }

    class RemoveFxSendAction
    extends AbstractAction {
        RemoveFxSendAction() {
            super(StdI18n.i18n.getLabel("JSFxSendsPane.RemoveFxSendAction"));
            String string = StdI18n.i18n.getLabel("JSFxSendsPane.RemoveFxSendAction.tt");
            this.putValue("ShortDescription", string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FxSend fxSend = JSFxSendsPane.this.fxSendsTable.getSelectedFxSend();
            if (fxSend == null) {
                return;
            }
            JSFxSendsPane.this.channelModel.removeBackendFxSend(fxSend.getFxSendId());
        }
    }

    class AddFxSendAction
    extends AbstractAction {
        private int fxSendId;

        AddFxSendAction() {
            super(StdI18n.i18n.getLabel("JSFxSendsPane.AddFxSendAction"));
            this.fxSendId = -1;
            String string = StdI18n.i18n.getLabel("JSFxSendsPane.AddFxSendAction.tt");
            this.putValue("ShortDescription", string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = JSFxSendsPane.this.channelModel.getChannelId();
            int n2 = JSFxSendsPane.this.getUndefinedController();
            JSFxSendsPane.this.lastUsedController = n2;
            final Channel.AddFxSend addFxSend = new Channel.AddFxSend(n, n2, "New effect send");
            addFxSend.addTaskListener(new TaskListener(){

                @Override
                public void taskPerformed(TaskEvent taskEvent) {
                    if (addFxSend.doneWithErrors()) {
                        AddFxSendAction.this.fxSendId = -1;
                        return;
                    }
                    AddFxSendAction.this.setFxSendId((Integer)addFxSend.getResult());
                }
            });
            CC.getTaskQueue().add(addFxSend);
        }

        public int getFxSendId() {
            return this.fxSendId;
        }

        public void setFxSendId(int n) {
            this.fxSendId = n;
        }
    }
}

