/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellRenderer;
import org.jsampler.DefaultOrchestraListModel;
import org.jsampler.OrchestraModel;
import org.jsampler.view.OrchestraTableModel;

public class OrchestraTable
extends JTable {
    public OrchestraTable() {
        this(new OrchestraTableModel(new DefaultOrchestraListModel()));
    }

    public OrchestraTable(OrchestraTableModel orchestraTableModel) {
        super(orchestraTableModel);
        this.setSelectionMode(0);
        this.setFillsViewportHeight(true);
        this.installKeyboardListeners();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 1) {
                    return;
                }
                int n = OrchestraTable.this.rowAtPoint(mouseEvent.getPoint());
                if (n == -1) {
                    OrchestraTable.this.clearSelection();
                    return;
                }
            }
        });
    }

    private void installKeyboardListeners() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        this.getInputMap(0).put(keyStroke, "clearSelection");
        this.getActionMap().put("clearSelection", new Actions("clearSelection"));
        keyStroke = KeyStroke.getKeyStroke(38, 9);
        this.getInputMap(0).put(keyStroke, "moveOrchestraOnTop");
        this.getActionMap().put("moveOrchestraOnTop", new Actions("moveOrchestraOnTop"));
        keyStroke = KeyStroke.getKeyStroke(38, 8);
        this.getInputMap(0).put(keyStroke, "moveOrchestraUp");
        this.getActionMap().put("moveOrchestraUp", new Actions("moveOrchestraUp"));
        keyStroke = KeyStroke.getKeyStroke(40, 8);
        this.getInputMap(0).put(keyStroke, "moveOrchestraDown");
        this.getActionMap().put("moveOrchestraDown", new Actions("moveOrchestraDown"));
        keyStroke = KeyStroke.getKeyStroke(40, 9);
        this.getInputMap(0).put(keyStroke, "moveOrchestraAtBottom");
        this.getActionMap().put("moveOrchestraAtBottom", new Actions("moveOrchestraAtBottom"));
    }

    @Override
    public OrchestraTableModel getModel() {
        return (OrchestraTableModel)super.getModel();
    }

    public void setModel(OrchestraTableModel orchestraTableModel) {
        super.setModel(orchestraTableModel);
    }

    public OrchestraModel getSelectedOrchestra() {
        int n = this.getSelectedRow();
        if (n == -1) {
            return null;
        }
        return this.getModel().getOrchestraListModel().getOrchestra(n);
    }

    public void setSelectedOrchestra(OrchestraModel orchestraModel) {
        int n = this.getModel().getOrchestraListModel().getOrchestraIndex(orchestraModel);
        if (n < 0) {
            this.clearSelection();
            return;
        }
        this.setRowSelectionInterval(n, n);
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        TableCellRenderer tableCellRenderer = super.getCellRenderer(n, n2);
        if (tableCellRenderer instanceof JComponent) {
            String string = this.getModel().getOrchestraListModel().getOrchestra(n).getDescription();
            if (string != null && string.length() == 0) {
                string = null;
            }
            ((JComponent)((Object)tableCellRenderer)).setToolTipText(string);
        }
        return tableCellRenderer;
    }

    private class Actions
    extends AbstractAction {
        private static final String CLEAR_SELECTION = "clearSelection";
        private static final String MOVE_ON_TOP = "moveOrchestraOnTop";
        private static final String MOVE_UP = "moveOrchestraUp";
        private static final String MOVE_DOWN = "moveOrchestraDown";
        private static final String MOVE_AT_BOTTOM = "moveOrchestraAtBottom";

        Actions(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.getValue("Name").toString();
            if (string == CLEAR_SELECTION) {
                OrchestraTable.this.clearSelection();
            } else if (string == MOVE_ON_TOP) {
                OrchestraModel orchestraModel = OrchestraTable.this.getSelectedOrchestra();
                OrchestraTable.this.getModel().getOrchestraListModel().moveOrchestraOnTop(orchestraModel);
                OrchestraTable.this.setSelectedOrchestra(orchestraModel);
            } else if (string == MOVE_UP) {
                OrchestraModel orchestraModel = OrchestraTable.this.getSelectedOrchestra();
                OrchestraTable.this.getModel().getOrchestraListModel().moveOrchestraUp(orchestraModel);
                OrchestraTable.this.setSelectedOrchestra(orchestraModel);
            } else if (string == MOVE_DOWN) {
                OrchestraModel orchestraModel = OrchestraTable.this.getSelectedOrchestra();
                OrchestraTable.this.getModel().getOrchestraListModel().moveOrchestraDown(orchestraModel);
                OrchestraTable.this.setSelectedOrchestra(orchestraModel);
            } else if (string == MOVE_AT_BOTTOM) {
                OrchestraModel orchestraModel = OrchestraTable.this.getSelectedOrchestra();
                OrchestraTable.this.getModel().getOrchestraListModel().moveOrchestraAtBottom(orchestraModel);
                OrchestraTable.this.setSelectedOrchestra(orchestraModel);
            }
        }
    }
}

