/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.file.nio;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class PositionTrackingFileChannelInputStream
extends InputStream {
    private final FileChannel channel;
    private long position;

    public PositionTrackingFileChannelInputStream(FileChannel channel, long position) {
        this.channel = channel;
        this.position = position;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int read = this.read(b, 0, 1);
        return read == -1 ? -1 : b[0] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.channel.read(ByteBuffer.wrap(b, off, len), this.position);
        if (read > 0) {
            this.position += (long)read;
        }
        return read;
    }
}

