/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.filesleuth.extract;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.TimeZone;
import tim.prune.function.filesleuth.data.LocationFilter;
import tim.prune.function.filesleuth.data.TrackContents;
import tim.prune.function.filesleuth.extract.ContentExtractor;
import tim.prune.function.filesleuth.extract.ContentReceiver;
import tim.prune.function.filesleuth.extract.XmlParser;

public class XmlFileExtractor
implements ContentExtractor,
ContentReceiver {
    private final File _file;
    private final InputStream _stream;
    private TrackContents _contents = null;
    private LocationFilter _locationFilter = null;
    private final Object _mutex = new Object();
    private boolean _filterMatched = false;
    private boolean _finishedParsing = false;

    public XmlFileExtractor(File file) {
        this._file = file;
        this._stream = null;
    }

    public XmlFileExtractor(InputStream inputStream) {
        this._file = null;
        this._stream = inputStream;
    }

    @Override
    public TrackContents getContents(TimeZone timeZone) {
        this._contents = new TrackContents(timeZone);
        this._locationFilter = null;
        this.readFile();
        return this._contents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFile() {
        Object object = this._mutex;
        synchronized (object) {
            this._finishedParsing = false;
            XmlParser xmlParser = new XmlParser(this);
            if (this._file != null) {
                try {
                    Throwable throwable = null;
                    Object var4_5 = null;
                    try (FileInputStream fileInputStream = new FileInputStream(this._file);){
                        if (!xmlParser.parseXmlStream(fileInputStream)) {
                            this._finishedParsing = true;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    this._finishedParsing = true;
                }
            } else if (this._stream == null || !xmlParser.parseXmlStream(this._stream)) {
                this._finishedParsing = true;
            }
            while (!this._finishedParsing) {
                try {
                    this._mutex.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endDocument() {
        Object object = this._mutex;
        synchronized (object) {
            this._finishedParsing = true;
            this._mutex.notifyAll();
        }
    }

    @Override
    public void addString(String string) {
        if (this._contents != null) {
            this._contents.addString(string);
        }
    }

    @Override
    public void setName(String string) {
        if (this._contents != null) {
            this._contents.setName(string);
        }
    }

    @Override
    public void setDescription(String string) {
        if (this._contents != null) {
            this._contents.setDescription(string);
        }
    }

    @Override
    public void addDateString(String string) {
        if (this._contents != null) {
            this._contents.addDateString(string);
        }
    }

    @Override
    public void addCoordinates(double d, double d2) {
        if (this._contents != null) {
            this._contents.addCoordinates(d, d2);
        } else if (this._locationFilter != null && !this._filterMatched) {
            this._filterMatched = this._locationFilter.doesLocationMatch(d, d2);
        }
    }

    @Override
    public boolean matchesFilter(LocationFilter locationFilter) {
        this._locationFilter = locationFilter;
        this._contents = null;
        this._filterMatched = false;
        this.readFile();
        return this._filterMatched;
    }
}

