/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.exporter.preview;

import java.io.OutputStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.gephi.io.exporter.spi.ByteExporter;
import org.gephi.io.exporter.spi.VectorExporter;
import org.gephi.preview.api.PDFTarget;
import org.gephi.preview.api.PreviewController;
import org.gephi.preview.api.PreviewProperties;
import org.gephi.preview.api.RenderTarget;
import org.gephi.project.api.Workspace;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class PDFExporter
implements ByteExporter,
VectorExporter,
LongTask {
    private ProgressTicket progress;
    private Workspace workspace;
    private OutputStream stream;
    private boolean cancel = false;
    private PDFTarget target;
    private float marginTop = 18.0f;
    private float marginBottom = 18.0f;
    private float marginLeft = 18.0f;
    private float marginRight = 18.0f;
    private boolean landscape = false;
    private PDRectangle pageSize = PDRectangle.A4;
    private boolean transparentBackground = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() {
        Progress.start((ProgressTicket)this.progress);
        PreviewController controller = (PreviewController)Lookup.getDefault().lookup(PreviewController.class);
        controller.getModel(this.workspace).getProperties().putValue("visibility-ratio", (Object)1.0);
        controller.refreshPreview(this.workspace);
        PreviewProperties props = controller.getModel(this.workspace).getProperties();
        try (PDDocument doc = new PDDocument();){
            doc.setVersion(1.5f);
            PDRectangle size = this.landscape ? new PDRectangle(this.pageSize.getHeight(), this.pageSize.getWidth()) : this.pageSize;
            PDPage page = new PDPage(size);
            doc.addPage(page);
            try (PDPageContentStream contentStream = new PDPageContentStream(doc, page);){
                props.putValue("pdf.landscape", (Object)this.landscape);
                props.putValue("pdf.pagesize", (Object)size);
                props.putValue("pdf.margin.top", (Object)Float.valueOf(this.marginTop));
                props.putValue("pdf.margin.left", (Object)Float.valueOf(this.marginLeft));
                props.putValue("pfd.margin.bottom", (Object)Float.valueOf(this.marginBottom));
                props.putValue("pdf.margin.right", (Object)Float.valueOf(this.marginRight));
                props.putValue("pdf.contentbyte", (Object)contentStream);
                props.putValue("pdf.document", (Object)doc);
                props.putValue("pdf.transparent.background", (Object)this.transparentBackground);
                this.target = (PDFTarget)controller.getRenderTarget("pdf", this.workspace);
                if (this.target instanceof LongTask) {
                    ((LongTask)this.target).setProgressTicket(this.progress);
                }
                controller.render((RenderTarget)this.target, this.workspace);
            }
            doc.save(this.stream);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            Progress.finish((ProgressTicket)this.progress);
            props.putValue("pdf.contentbyte", null);
            props.putValue("pdf.pagesize", null);
            props.putValue("pdf.document", null);
        }
        return !this.cancel;
    }

    public boolean isLandscape() {
        return this.landscape;
    }

    public void setLandscape(boolean landscape) {
        this.landscape = landscape;
    }

    public float getMarginBottom() {
        return this.marginBottom;
    }

    public void setMarginBottom(float marginBottom) {
        this.marginBottom = marginBottom;
    }

    public float getMarginLeft() {
        return this.marginLeft;
    }

    public void setMarginLeft(float marginLeft) {
        this.marginLeft = marginLeft;
    }

    public float getMarginRight() {
        return this.marginRight;
    }

    public void setMarginRight(float marginRight) {
        this.marginRight = marginRight;
    }

    public float getMarginTop() {
        return this.marginTop;
    }

    public void setMarginTop(float marginTop) {
        this.marginTop = marginTop;
    }

    public PDRectangle getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(PDRectangle pageSize) {
        this.pageSize = pageSize;
    }

    public boolean isTransparentBackground() {
        return this.transparentBackground;
    }

    public void setTransparentBackground(boolean transparentBackground) {
        this.transparentBackground = transparentBackground;
    }

    public void setOutputStream(OutputStream stream) {
        this.stream = stream;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public boolean cancel() {
        this.cancel = true;
        if (this.target instanceof LongTask) {
            ((LongTask)this.target).cancel();
        }
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progress = progressTicket;
    }
}

