/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.ui;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.validation.api.Problem;
import org.netbeans.validation.api.ui.ValidationUI;

final class MulticastValidationUI
implements ValidationUI {
    private final Set<ValidationUI> real;

    MulticastValidationUI(ValidationUI ... real) {
        this.real = new HashSet<ValidationUI>(Arrays.asList(real));
        assert (this.validUIs(real));
    }

    public void add(ValidationUI ui) {
        if (ui == null) {
            throw new NullPointerException();
        }
        assert (!this.contains(ui)) : "Already a member: " + ui;
        this.real.add(ui);
    }

    public void remove(ValidationUI ui) {
        if (ui == null) {
            throw new NullPointerException();
        }
        assert (this.contains(ui)) : "Not a member: " + ui;
        this.real.remove(ui);
    }

    public boolean contains(ValidationUI check) {
        boolean result;
        block1: {
            ValidationUI ui;
            result = this.real.contains(check);
            if (result) break block1;
            Iterator<ValidationUI> iterator = this.real.iterator();
            while (!(!iterator.hasNext() || (ui = iterator.next()) instanceof MulticastValidationUI && (result = ((MulticastValidationUI)ui).contains(check)))) {
            }
        }
        return result;
    }

    @Override
    public void showProblem(Problem problem) {
        assert (this.real != null);
        for (ValidationUI ui : this.real) {
            ui.showProblem(problem);
        }
    }

    public boolean validUIs(ValidationUI[] uis) {
        for (int i = 0; i < uis.length; ++i) {
            ValidationUI ui = uis[i];
            if (ui != null) continue;
            throw new NullPointerException("Element " + i + " of ui array is null");
        }
        return true;
    }

    @Override
    public void clearProblem() {
        assert (this.real != null);
        for (ValidationUI ui : this.real) {
            ui.clearProblem();
        }
    }
}

