/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.generator.plugin;

import java.util.Random;
import org.gephi.graph.api.TimeRepresentation;
import org.gephi.io.generator.spi.Generator;
import org.gephi.io.generator.spi.GeneratorUI;
import org.gephi.io.importer.api.ColumnDraft;
import org.gephi.io.importer.api.ContainerLoader;
import org.gephi.io.importer.api.EdgeDraft;
import org.gephi.io.importer.api.NodeDraft;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.NbBundle;

public class DynamicGraph
implements Generator {
    protected int numberOfNodes = 50;
    protected double wiringProbability = 0.05;

    public void generate(ContainerLoader container) {
        int i;
        Random random = new Random();
        double start = 2000.0;
        double end = 2015.0;
        double tick = 1.0;
        ColumnDraft col = container.addNodeColumn("score", Integer.class, true);
        container.setTimeRepresentation(TimeRepresentation.TIMESTAMP);
        NodeDraft[] nodeArray = new NodeDraft[this.numberOfNodes];
        for (i = 0; i < this.numberOfNodes; ++i) {
            NodeDraft nodeDraft = container.factory().newNodeDraft("n" + i);
            container.addNode(nodeDraft);
            Random r = new Random();
            for (double t = start; t < end; t += tick) {
                if (!r.nextBoolean()) continue;
                nodeDraft.addTimestamp(t);
                nodeDraft.setValue(col.getId(), (Object)r.nextInt(5), t);
            }
            nodeArray[i] = nodeDraft;
        }
        if (this.wiringProbability > 0.0) {
            for (i = 0; i < this.numberOfNodes - 1; ++i) {
                NodeDraft node1 = nodeArray[i];
                for (int j = i + 1; j < this.numberOfNodes; ++j) {
                    NodeDraft node2 = nodeArray[j];
                    if (!(random.nextDouble() < this.wiringProbability)) continue;
                    EdgeDraft edgeDraft = container.factory().newEdgeDraft();
                    edgeDraft.setSource(node1);
                    edgeDraft.setTarget(node2);
                    Random r = new Random();
                    container.addEdge(edgeDraft);
                }
            }
        }
    }

    public String getName() {
        return NbBundle.getMessage(DynamicGraph.class, (String)"DynamicGraph.name");
    }

    public GeneratorUI getUI() {
        return null;
    }

    public boolean cancel() {
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
    }
}

