/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.importer.plugin.spreadsheet.wizard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.gephi.io.importer.plugin.file.spreadsheet.AbstractImporterSpreadsheet;
import org.gephi.io.importer.plugin.file.spreadsheet.process.SpreadsheetGeneralConfiguration;
import org.gephi.io.importer.plugin.file.spreadsheet.sheet.SheetParser;
import org.gephi.io.importer.plugin.file.spreadsheet.sheet.SheetRow;

public abstract class AbstractWizardVisualPanel1
extends JPanel {
    protected static final int MAX_ROWS_PREVIEW = 25;
    private final AbstractImporterSpreadsheet importer;
    protected int columnCount = 0;
    protected boolean hasSourceNodeColumn = false;
    protected boolean hasTargetNodeColumn = false;
    protected boolean hasRowsMissingSourcesOrTargets = false;

    public AbstractWizardVisualPanel1(AbstractImporterSpreadsheet importer) {
        this.importer = importer;
    }

    public void refreshPreviewTable() {
        try (SheetParser parser = this.importer.createParser();){
            Map headerMap = parser.getHeaderMap();
            final String[] headers = headerMap.keySet().toArray(new String[0]);
            this.columnCount = headers.length;
            this.hasSourceNodeColumn = false;
            this.hasTargetNodeColumn = false;
            int sourceColumnIndex = 0;
            int targetColumnIndex = 0;
            for (String header : headers) {
                if (header.equalsIgnoreCase("source")) {
                    this.hasSourceNodeColumn = true;
                    sourceColumnIndex = (Integer)headerMap.get(header);
                }
                if (!header.equalsIgnoreCase("target")) continue;
                this.hasTargetNodeColumn = true;
                targetColumnIndex = (Integer)headerMap.get(header);
            }
            ArrayList<String[]> records = new ArrayList<String[]>();
            this.hasRowsMissingSourcesOrTargets = false;
            SpreadsheetGeneralConfiguration.Mode mode = this.getSelectedMode();
            int maxRowSize = 0;
            Iterator iterator = parser.iterator();
            int count = 0;
            while (iterator.hasNext() && count < 25) {
                ++count;
                SheetRow row = (SheetRow)iterator.next();
                int rowSize = row.size();
                maxRowSize = Math.max(maxRowSize, row.size());
                String[] currentRecord = new String[rowSize];
                for (int i = 0; i < rowSize; ++i) {
                    currentRecord[i] = row.get(i);
                }
                if (mode == SpreadsheetGeneralConfiguration.Mode.EDGES_TABLE && (rowSize <= sourceColumnIndex || rowSize <= targetColumnIndex || currentRecord[sourceColumnIndex] == null || currentRecord[targetColumnIndex] == null)) {
                    this.hasRowsMissingSourcesOrTargets = true;
                }
                records.add(currentRecord);
            }
            final String[] columnNames = headers;
            final String[][] values = (String[][])records.toArray((T[])new String[0][]);
            final int rowSize = maxRowSize;
            final JTable table = this.getPreviewTable();
            table.setModel(new TableModel(){

                @Override
                public int getRowCount() {
                    return values.length;
                }

                @Override
                public int getColumnCount() {
                    return rowSize;
                }

                @Override
                public String getColumnName(int columnIndex) {
                    if (columnIndex > columnNames.length - 1) {
                        return null;
                    }
                    return columnNames[columnIndex];
                }

                @Override
                public Class<?> getColumnClass(int columnIndex) {
                    return String.class;
                }

                @Override
                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return false;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    if (values[rowIndex].length > columnIndex) {
                        return values[rowIndex][columnIndex];
                    }
                    return null;
                }

                @Override
                public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                }

                @Override
                public void addTableModelListener(TableModelListener l) {
                }

                @Override
                public void removeTableModelListener(TableModelListener l) {
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    boolean needsHeader = headers.length > 0;
                    AbstractWizardVisualPanel1.this.getPreviewTableScrollPane().setColumnHeaderView(needsHeader ? table.getTableHeader() : null);
                }
            });
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected abstract JTable getPreviewTable();

    protected abstract JScrollPane getPreviewTableScrollPane();

    protected abstract SpreadsheetGeneralConfiguration.Mode getSelectedMode();
}

