/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicLabelUI;
import net.infonode.util.Direction;

public class RotatableLabelUI
extends BasicLabelUI {
    private static Rectangle paintIconR = new Rectangle();
    private static Rectangle paintTextR = new Rectangle();
    private static Rectangle paintViewR = new Rectangle();
    private Direction direction;
    private boolean mirror;

    public RotatableLabelUI(Direction direction) {
        this(direction, false);
    }

    public RotatableLabelUI(Direction direction, boolean mirror) {
        this.direction = direction;
        this.mirror = mirror;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public boolean isMirror() {
        return this.mirror;
    }

    public void setMirror(boolean mirror) {
        this.mirror = mirror;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        int m;
        Icon icon;
        JLabel label = (JLabel)c;
        String text = label.getText();
        Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        if (icon == null && text == null) {
            return;
        }
        FontMetrics fm = g.getFontMetrics();
        Insets insets = c.getInsets();
        RotatableLabelUI.paintViewR.x = insets.left;
        RotatableLabelUI.paintViewR.y = insets.top;
        if (this.direction.isHorizontal()) {
            RotatableLabelUI.paintViewR.height = c.getHeight() - (insets.top + insets.bottom);
            RotatableLabelUI.paintViewR.width = c.getWidth() - (insets.left + insets.right);
        } else {
            RotatableLabelUI.paintViewR.height = c.getWidth() - (insets.top + insets.bottom);
            RotatableLabelUI.paintViewR.width = c.getHeight() - (insets.left + insets.right);
        }
        RotatableLabelUI.paintIconR.height = 0;
        RotatableLabelUI.paintIconR.width = 0;
        RotatableLabelUI.paintIconR.y = 0;
        RotatableLabelUI.paintIconR.x = 0;
        RotatableLabelUI.paintTextR.height = 0;
        RotatableLabelUI.paintTextR.width = 0;
        RotatableLabelUI.paintTextR.y = 0;
        RotatableLabelUI.paintTextR.x = 0;
        String clippedText = this.layoutCL(label, fm, text, icon, paintViewR, paintIconR, paintTextR);
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform tr = g2.getTransform();
        int n = m = this.mirror ? -1 : 1;
        g2.transform(this.direction == Direction.RIGHT ? new AffineTransform(1.0f, 0.0f, 0.0f, m, 0.0f, this.mirror ? c.getHeight() : 0) : (this.direction == Direction.DOWN ? new AffineTransform(0.0f, 1.0f, -m, 0.0f, this.mirror ? 0 : c.getWidth(), 0.0f) : (this.direction == Direction.LEFT ? new AffineTransform(-1.0f, 0.0f, 0.0f, -m, c.getWidth(), this.mirror ? 0 : c.getHeight()) : new AffineTransform(0.0f, -1.0f, m, 0.0f, this.mirror ? c.getWidth() : 0, c.getHeight()))));
        if (icon != null) {
            icon.paintIcon(c, g, RotatableLabelUI.paintIconR.x, RotatableLabelUI.paintIconR.y);
        }
        if (text != null) {
            int textX = RotatableLabelUI.paintTextR.x;
            int textY = RotatableLabelUI.paintTextR.y + fm.getAscent();
            if (label.isEnabled()) {
                this.paintEnabledText(label, g, clippedText, textX, textY);
            } else {
                this.paintDisabledText(label, g, clippedText, textX, textY);
            }
        }
        g2.setTransform(tr);
    }
}

