/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.net.URI;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Predicate;

public class ProtocolRestrictor {
    private final Predicate<URI> predicate;
    private final String originalRule;

    public ProtocolRestrictor(String value) {
        Objects.requireNonNull(value);
        this.originalRule = value;
        value = value.trim();
        if (value.equals("all")) {
            this.predicate = uri -> true;
        } else {
            String[] tokens;
            ArrayList<Predicate<URI>> permitted = new ArrayList<Predicate<URI>>();
            for (String token : tokens = value.split(",\\s*")) {
                if (token.startsWith("jar:") && token.length() > 4) {
                    String subScheme = token.substring(4).toLowerCase();
                    permitted.add(uri -> ProtocolRestrictor.scheme(uri).equals("jar") && ProtocolRestrictor.schemeSpecificPart(uri).toLowerCase().startsWith(subScheme));
                    continue;
                }
                permitted.add(uri -> ProtocolRestrictor.scheme(uri).equals(token));
            }
            this.predicate = uri -> {
                for (Predicate pred : permitted) {
                    if (!pred.test(uri)) continue;
                    return true;
                }
                return false;
            };
        }
    }

    public boolean test(URI uri) {
        return this.predicate.test(uri);
    }

    public String toString() {
        return this.originalRule;
    }

    private static String scheme(URI uri) {
        return uri.getScheme();
    }

    private static String schemeSpecificPart(URI uri) {
        return uri.getSchemeSpecificPart();
    }
}

