/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions.datasource;

import java.net.PasswordAuthentication;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.core.DBeaverActivator;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressListener;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBServiceConnections;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceConnections;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceHandler;
import org.jkiss.dbeaver.ui.dialogs.connection.EditConnectionDialog;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class UIServiceConnectionsImpl
implements DBServiceConnections,
UIServiceConnections {
    private final IProxyService proxyService;

    public UIServiceConnectionsImpl() {
        BundleContext bundleContext = DBeaverActivator.getInstance().getBundle().getBundleContext();
        ServiceReference proxyServiceRef = bundleContext.getServiceReference(IProxyService.class);
        this.proxyService = proxyServiceRef != null ? (IProxyService)bundleContext.getService(proxyServiceRef) : null;
    }

    public void openConnectionEditor(@NotNull DBPDataSourceContainer dataSourceContainer, String defaultPageName) {
        if (dataSourceContainer.getProject().hasRealmPermission("project-datasource-edit")) {
            if (dataSourceContainer.getProject().isUseSecretStorage() && !dataSourceContainer.isSharedCredentials()) {
                try {
                    DBSSecretController secretController = DBSSecretController.getProjectSecretController((DBPProject)dataSourceContainer.getProject());
                    dataSourceContainer.resolveSecrets(secretController);
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError("Secret resolve", "Error loading connection secrets", (Throwable)e);
                }
            }
            EditConnectionDialog.openEditConnectionDialog(UIUtils.getActiveWorkbenchWindow(), dataSourceContainer, defaultPageName);
        } else {
            DBWorkbench.getPlatformUI().openEntityEditor((DBSObject)dataSourceContainer);
        }
    }

    public void connectDataSource(@NotNull DBPDataSourceContainer dataSourceContainer, DBRProgressListener onFinish) {
        DataSourceHandler.connectToDataSource(null, (DBPDataSourceContainer)dataSourceContainer, (DBRProgressListener)onFinish);
    }

    public void disconnectDataSource(@NotNull DBPDataSourceContainer dataSourceContainer) {
        DataSourceHandler.disconnectDataSource((DBPDataSourceContainer)dataSourceContainer, null);
    }

    public void closeActiveTransaction(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext context, boolean commitTxn) {
        DataSourceHandler.closeActiveTransaction((DBRProgressMonitor)monitor, (DBCExecutionContext)context, (boolean)commitTxn);
    }

    public boolean confirmTransactionsClose(@NotNull DBCExecutionContext[] contexts) {
        return DataSourceHandler.confirmTransactionsClose((DBCExecutionContext[])contexts);
    }

    public boolean checkAndCloseActiveTransaction(@NotNull DBCExecutionContext[] contexts) {
        return DataSourceHandler.checkAndCloseActiveTransaction((DBCExecutionContext[])contexts, (boolean)false);
    }

    @Nullable
    public PasswordAuthentication getGlobalProxyConfiguration(@NotNull String requestingProtocol, @Nullable String requestingHost, int requestingPort) {
        IProxyData[] proxyData;
        if (this.proxyService != null && (proxyData = this.proxyService.getProxyData()) != null) {
            for (IProxyData pd : proxyData) {
                if (!requestingProtocol.startsWith(pd.getType()) || pd.getUserId() == null || pd.getHost() == null || pd.getPort() != requestingPort || !pd.getHost().equalsIgnoreCase(requestingHost)) continue;
                return new PasswordAuthentication(pd.getUserId(), pd.getPassword().toCharArray());
            }
        }
        return null;
    }

    public void initConnection(DBRProgressMonitor monitor, DBPDataSourceContainer dataSourceContainer, DBRProgressListener onFinish) {
        DataSourceHandler.connectToDataSource((DBRProgressMonitor)monitor, (DBPDataSourceContainer)dataSourceContainer, (DBRProgressListener)onFinish);
    }
}

