/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlin.text.UStringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Actuals_jvmKt;
import org.jetbrains.skia.FourByteTag;
import org.jetbrains.skia.impl.InteropScope;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 '2\u00020\u0001:\u0001'B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tB)\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\fB\u0019\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\rB\u0019\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0004\u001a\u00020\u000e\u00a2\u0006\u0004\b\b\u0010\u000fB\u0011\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\b\u0010\u0010J\b\u0010\u001a\u001a\u00020\u000bH\u0016J\u0013\u0010\u001b\u001a\u00020\u000e2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001d\u001a\u00020\u0003H\u0016J\r\u0010\u001e\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b J\u0017\u0010!\u001a\u00060#j\u0002`\"*\u00020$H\u0000\u00a2\u0006\u0004\b%\u0010&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0013\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0014\u0010\u0012R\u0013\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\u0017\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006("}, d2={"Lorg/jetbrains/skia/FontFeature;", "", "_tag", "", "value", "start", "Lkotlin/UInt;", "end", "<init>", "(IIIILkotlin/jvm/internal/DefaultConstructorMarker;)V", "feature", "", "(Ljava/lang/String;IIILkotlin/jvm/internal/DefaultConstructorMarker;)V", "(Ljava/lang/String;I)V", "", "(Ljava/lang/String;Z)V", "(Ljava/lang/String;)V", "get_tag", "()I", "getValue", "getStart-pVg5ArA", "I", "getEnd-pVg5ArA", "tag", "getTag", "()Ljava/lang/String;", "toString", "equals", "other", "hashCode", "toInteropIntArray", "", "toInteropIntArray$skiko", "toInterop", "Lorg/jetbrains/skia/impl/InteropPointer;", "Ljava/lang/Object;", "Lorg/jetbrains/skia/impl/InteropScope;", "toInterop$skiko", "(Lorg/jetbrains/skia/impl/InteropScope;)Ljava/lang/Object;", "Companion", "skiko"})
public final class FontFeature {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int _tag;
    private final int value;
    private final int start;
    private final int end;
    public static final int GLOBAL_START = 0;
    public static final int GLOBAL_END = -1;
    @NotNull
    private static final FontFeature[] EMPTY = new FontFeature[0];
    @NotNull
    private static final Pattern _splitPattern = Actuals_jvmKt.compilePattern("\\s+");
    @NotNull
    private static final Pattern _featurePattern = Actuals_jvmKt.compilePattern("([-+])?([a-z0-9]{4})(?:\\[(\\d+)?:(\\d+)?\\])?(?:=(\\d+))?");
    private static final int signIx = 1;
    private static final int tagIx = 2;
    private static final int startIx = 3;
    private static final int endIx = 4;
    private static final int valueIx = 5;

    private FontFeature(int _tag, int value, int start2, int end) {
        this._tag = _tag;
        this.value = value;
        this.start = start2;
        this.end = end;
    }

    public final int get_tag() {
        return this._tag;
    }

    public final int getValue() {
        return this.value;
    }

    public final int getStart-pVg5ArA() {
        return this.start;
    }

    public final int getEnd-pVg5ArA() {
        return this.end;
    }

    private FontFeature(String feature, int value, int start2, int end) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        this(FourByteTag.Companion.fromString(feature), value, start2, end, null);
    }

    public FontFeature(@NotNull String feature, int value) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        this(FourByteTag.Companion.fromString(feature), value, 0, -1, null);
    }

    public FontFeature(@NotNull String feature, boolean value) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        this(FourByteTag.Companion.fromString(feature), value ? 1 : 0, 0, -1, null);
    }

    public FontFeature(@NotNull String feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        this(FourByteTag.Companion.fromString(feature), 1, 0, -1, null);
    }

    @NotNull
    public final String getTag() {
        return FourByteTag.Companion.toString(this._tag);
    }

    @NotNull
    public String toString() {
        String range = "";
        if (Integer.compareUnsigned(this.start, 0) > 0 || Integer.compareUnsigned(this.end, -1) < 0) {
            range = "" + '[' + (Integer.compareUnsigned(this.start, 0) > 0 ? UInt.box-impl((int)this.start) : (Comparable)((Object)"")) + ':' + (Integer.compareUnsigned(this.end, -1) < 0 ? UInt.box-impl((int)this.end) : (Comparable)((Object)"")) + ']';
        }
        String valuePrefix = "";
        String valueSuffix = "";
        if (this.value == 0) {
            valuePrefix = "-";
        } else if (this.value == 1) {
            valuePrefix = "+";
        } else {
            valueSuffix = "" + '=' + this.value;
        }
        return "FontFeature(" + valuePrefix + this._tag + range + valueSuffix + ')';
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FontFeature)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getTag(), (Object)((FontFeature)other).getTag())) {
            return false;
        }
        if (this.value != ((FontFeature)other).value) {
            return false;
        }
        if (this.start != ((FontFeature)other).start) {
            return false;
        }
        return this.end == ((FontFeature)other).end;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * PRIME + Integer.hashCode(this._tag);
        result = result * PRIME + this.value;
        result = result * PRIME + UInt.constructor-impl((int)(UInt.constructor-impl((int)(this.start >>> 16)) ^ this.start));
        result = result * PRIME + UInt.constructor-impl((int)(UInt.constructor-impl((int)(this.end >>> 16)) ^ this.end));
        return result;
    }

    @NotNull
    public final int[] toInteropIntArray$skiko() {
        int[] nArray = new int[]{this._tag, this.value, this.start, this.end};
        return nArray;
    }

    @NotNull
    public final Object toInterop$skiko(@NotNull InteropScope $this$toInterop) {
        Intrinsics.checkNotNullParameter((Object)$this$toInterop, (String)"<this>");
        return $this$toInterop.toInterop(this.toInteropIntArray$skiko());
    }

    public /* synthetic */ FontFeature(int _tag, int value, int start2, int end, DefaultConstructorMarker $constructor_marker) {
        this(_tag, value, start2, end);
    }

    public /* synthetic */ FontFeature(String feature, int value, int start2, int end, DefaultConstructorMarker $constructor_marker) {
        this(feature, value, start2, end);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0019\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010 \u001a\u00020\u001e\u00a2\u0006\u0002\u0010!J\u0019\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010 \u001a\u00020\u001e\u00a2\u0006\u0002\u0010!J'\u0010#\u001a\u00060%j\u0002`$*\u00020&2\u000e\u0010'\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u0000\u00a2\u0006\u0004\b(\u0010)J\u001d\u0010*\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010'\u001a\u00020+H\u0000\u00a2\u0006\u0004\b,\u0010-R\u0010\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0010\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u001b\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u000e\u001a\u00060\u0010j\u0002`\u000f\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0014\u001a\u00060\u0010j\u0002`\u000f\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0015\u0010\u0012R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0017X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0017X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0017X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/skia/FontFeature$Companion;", "", "<init>", "()V", "GLOBAL_START", "Lkotlin/UInt;", "I", "GLOBAL_END", "EMPTY", "", "Lorg/jetbrains/skia/FontFeature;", "getEMPTY", "()[Lorg/jetbrains/skia/FontFeature;", "[Lorg/jetbrains/skia/FontFeature;", "_splitPattern", "Lorg/jetbrains/skia/Pattern;", "Ljava/util/regex/Pattern;", "get_splitPattern", "()Ljava/util/regex/Pattern;", "Ljava/util/regex/Pattern;", "_featurePattern", "get_featurePattern", "signIx", "", "tagIx", "startIx", "endIx", "valueIx", "parseOne", "s", "", "parse", "str", "(Ljava/lang/String;)[Lorg/jetbrains/skia/FontFeature;", "parseW3", "arrayOfFontFeaturesToInterop", "Lorg/jetbrains/skia/impl/InteropPointer;", "Ljava/lang/Object;", "Lorg/jetbrains/skia/impl/InteropScope;", "fontFeatures", "arrayOfFontFeaturesToInterop$skiko", "(Lorg/jetbrains/skia/impl/InteropScope;[Lorg/jetbrains/skia/FontFeature;)Ljava/lang/Object;", "fromInteropEncodedBy2Ints", "", "fromInteropEncodedBy2Ints$skiko", "([I)[Lorg/jetbrains/skia/FontFeature;", "skiko"})
    @SourceDebugExtension(value={"SMAP\nFontFeature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FontFeature.kt\norg/jetbrains/skia/FontFeature$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,172:1\n1#2:173\n11102#3:174\n11437#3,3:175\n13411#3,3:182\n37#4,2:178\n37#4,2:180\n*S KotlinDebug\n*F\n+ 1 FontFeature.kt\norg/jetbrains/skia/FontFeature$Companion\n*L\n111#1:174\n111#1:175,3\n144#1:182,3\n111#1:178,2\n139#1:180,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FontFeature[] getEMPTY() {
            return EMPTY;
        }

        @NotNull
        public final Pattern get_splitPattern() {
            return _splitPattern;
        }

        @NotNull
        public final Pattern get_featurePattern() {
            return _featurePattern;
        }

        @NotNull
        public final FontFeature parseOne(@NotNull String s) {
            int n;
            int start2;
            int n2;
            int value;
            int n3;
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            Matcher m = this.get_featurePattern().matcher(s);
            if (!m.matches()) {
                boolean $i$a$-require-FontFeature$Companion$parseOne$22 = false;
                String $i$a$-require-FontFeature$Companion$parseOne$22 = "Can\u2019t parse FontFeature: " + s;
                throw new IllegalArgumentException($i$a$-require-FontFeature$Companion$parseOne$22.toString());
            }
            if (m.group(5) != null) {
                String string = m.group(5);
                Intrinsics.checkNotNull((Object)string);
                n3 = Integer.parseInt(string);
            } else {
                n3 = m.group(1) == null ? 1 : (value = Intrinsics.areEqual((Object)"-", (Object)m.group(1)) ? 0 : 1);
            }
            if (m.group(3) == null) {
                n2 = 0;
            } else {
                String string = m.group(3);
                Intrinsics.checkNotNull((Object)string);
                n2 = start2 = UStringsKt.toUInt((String)string);
            }
            if (m.group(4) == null) {
                n = -1;
            } else {
                String string = m.group(4);
                Intrinsics.checkNotNull((Object)string);
                n = UStringsKt.toUInt((String)string);
            }
            int end = n;
            String string = m.group(2);
            Intrinsics.checkNotNull((Object)string);
            return new FontFeature(string, value, start2, end, null);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final FontFeature[] parse(@NotNull String str) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            String[] $this$map$iv = this.get_splitPattern().split(str);
            boolean $i$f$map = false;
            String[] stringArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void s;
                void item$iv$iv;
                void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.parseOne((String)s));
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new FontFeature[0]);
        }

        @NotNull
        public final FontFeature[] parseW3(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            String[] stringArray = new String[]{","};
            Collection $this$toTypedArray$iv = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)StringsKt.splitToSequence$default((CharSequence)str, (String[])stringArray, (boolean)false, (int)0, (int)6, null), Companion::parseW3$lambda$2));
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new FontFeature[0]);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Object arrayOfFontFeaturesToInterop$skiko(@NotNull InteropScope $this$arrayOfFontFeaturesToInterop, @Nullable FontFeature[] fontFeatures) {
            int[] ints;
            block1: {
                Intrinsics.checkNotNullParameter((Object)$this$arrayOfFontFeaturesToInterop, (String)"<this>");
                ints = new int[4 * (fontFeatures != null ? fontFeatures.length : 0)];
                if (fontFeatures == null) break block1;
                FontFeature[] $this$forEachIndexed$iv = fontFeatures;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (FontFeature item$iv : $this$forEachIndexed$iv) {
                    void fontFeature;
                    int n = index$iv++;
                    FontFeature fontFeature2 = item$iv;
                    int ix = n;
                    boolean bl = false;
                    int j = ix * 4;
                    ints[j] = fontFeature.get_tag();
                    ints[j + 1] = fontFeature.getValue();
                    ints[j + 2] = fontFeature.getStart-pVg5ArA();
                    ints[j + 3] = fontFeature.getEnd-pVg5ArA();
                }
            }
            return $this$arrayOfFontFeaturesToInterop.toInterop(ints);
        }

        @NotNull
        public final FontFeature[] fromInteropEncodedBy2Ints$skiko(@NotNull int[] fontFeatures) {
            Intrinsics.checkNotNullParameter((Object)fontFeatures, (String)"fontFeatures");
            int featuresCount = fontFeatures.length / 2;
            int n = 0;
            FontFeature[] fontFeatureArray = new FontFeature[featuresCount];
            while (n < featuresCount) {
                int n2 = n++;
                int j = n2 * 2;
                fontFeatureArray[n2] = new FontFeature(fontFeatures[j], fontFeatures[j + 1], 0, -1, null);
            }
            return fontFeatureArray;
        }

        private static final FontFeature parseW3$lambda$2(String it) {
            int n;
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            String[] stringArray = new String[]{" "};
            List parts = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            String name = (String)parts.get(0);
            String value = (String)CollectionsKt.getOrNull((List)parts, (int)1);
            if (Intrinsics.areEqual((Object)value, (Object)"on") || value == null) {
                n = 1;
            } else if (Intrinsics.areEqual((Object)value, (Object)"off")) {
                n = 0;
            } else {
                Integer n2 = StringsKt.toIntOrNull((String)value);
                n = n2 != null ? n2 : 1;
            }
            int value2 = n;
            return name.length() == 4 ? new FontFeature(name, value2) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

