/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.validation.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.validation.checkers.IrElementChecker;
import org.jetbrains.kotlin.ir.validation.checkers.context.CheckerContext;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/ir/validation/checkers/expression/IrCallValueArgumentCountChecker;", "Lorg/jetbrains/kotlin/ir/validation/checkers/IrElementChecker;", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "<init>", "()V", "check", "", "element", "context", "Lorg/jetbrains/kotlin/ir/validation/checkers/context/CheckerContext;", "ir.validation"})
public final class IrCallValueArgumentCountChecker
extends IrElementChecker<IrFunctionAccessExpression> {
    @NotNull
    public static final IrCallValueArgumentCountChecker INSTANCE = new IrCallValueArgumentCountChecker();

    private IrCallValueArgumentCountChecker() {
        super(Reflection.getOrCreateKotlinClass(IrFunctionAccessExpression.class));
    }

    @Override
    public void check(@NotNull IrFunctionAccessExpression element, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        IrFunction function = ((IrFunctionSymbol)element.getSymbol()).getOwner();
        if (element.getArguments().size() != function.getParameters().size()) {
            context2.error(this, element, "The call provides " + element.getArguments().size() + " argument(s) but the called function has " + function.getParameters().size() + " parameter(s)");
        }
    }
}

