/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.console;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtilsKt;
import org.jetbrains.plugins.groovy.util.ModuleChooserUtil;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0019\u0010\u0000\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0001*\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u0004\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0000\u001a\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0003H\u0000\u001a\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0007\u001a\u00020\u0002\u001a\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0000\u001a\u0017\u0010\u000f\u001a\t\u0018\u00010\r\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0007\u001a\u00020\u0002H\u0000\u001a\u0018\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\rH\u0002\u00a8\u0006\u0012"}, d2={"modules", "", "Lcom/intellij/openapi/module/Module;", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)[Lcom/intellij/openapi/module/Module;", "isApplicableModule", "", "module", "hasAnyApplicableModule", "project", "getApplicableModules", "", "getWorkingDirectory", "", "hasNeededDependenciesToRunConsole", "sdkVersionIfHasNeededDependenciesToRunConsole", "Lcom/intellij/openapi/util/NlsSafe;", "sdkVersion", "intellij.groovy"})
@SourceDebugExtension(value={"SMAP\nGroovyConsoleUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroovyConsoleUtil.kt\norg/jetbrains/plugins/groovy/console/GroovyConsoleUtilKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,58:1\n12970#2,2:59\n3919#2:61\n4434#2,2:62\n*S KotlinDebug\n*F\n+ 1 GroovyConsoleUtil.kt\norg/jetbrains/plugins/groovy/console/GroovyConsoleUtilKt\n*L\n21#1:59,2\n23#1:61\n23#1:62,2\n*E\n"})
public final class GroovyConsoleUtilKt {
    private static final Module[] modules(Project $this$modules) {
        return ModuleManager.Companion.getInstance($this$modules).getModules();
    }

    public static final boolean isApplicableModule(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return ModuleChooserUtil.hasJavaSdk(module) && ModuleChooserUtil.hasAcceptableModuleType(module);
    }

    public static final boolean hasAnyApplicableModule(@NotNull Project project) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Module[] $this$any$iv = GroovyConsoleUtilKt.modules(project);
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int j = 0; j < n; ++j) {
                Module element$iv;
                Module p0 = element$iv = $this$any$iv[j];
                boolean bl2 = false;
                if (!GroovyConsoleUtilKt.isApplicableModule(p0)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Module> getApplicableModules(@NotNull Project project) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Module[] $this$filter$iv = GroovyConsoleUtilKt.modules(project);
        boolean $i$f$filter = false;
        Module[] moduleArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void p0 = element$iv$iv = $this$filterTo$iv$iv[j];
            boolean bl = false;
            if (!GroovyConsoleUtilKt.isApplicableModule((Module)p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final String getWorkingDirectory(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module).getContentRoots();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
        Object object = (VirtualFile)ArraysKt.firstOrNull((Object[])virtualFileArray);
        if (object == null || (object = object.getPath()) == null) {
            object = module.getProject().getBasePath();
        }
        return object;
    }

    public static final boolean hasNeededDependenciesToRunConsole(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        String sdkVersion = GroovyConfigUtilsKt.getSdkVersion(module);
        return sdkVersion != null && GroovyConsoleUtilKt.hasNeededDependenciesToRunConsole(module, sdkVersion);
    }

    @Nullable
    public static final String sdkVersionIfHasNeededDependenciesToRunConsole(@NotNull Module module) {
        String string;
        String sdkVersion;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        String string2 = sdkVersion = GroovyConfigUtilsKt.getSdkVersion(module);
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            string = GroovyConsoleUtilKt.hasNeededDependenciesToRunConsole(module, it) ? string3 : null;
        } else {
            string = null;
        }
        return string;
    }

    private static final boolean hasNeededDependenciesToRunConsole(Module module, String sdkVersion) {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"moduleWithDependenciesAndLibrariesScope(...)");
        GlobalSearchScope scope = globalSearchScope;
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        if (facade.findClass("groovy.ui.GroovyMain", scope) == null) {
            return false;
        }
        if (StringUtil.compareVersionNumbers((String)sdkVersion, (String)"2.3") >= 0) {
            return true;
        }
        return facade.findClass("org.apache.commons.cli.CommandLineParser", scope) != null || facade.findClass("groovyjarjarcommonscli.CommandLineParser", scope) != null;
    }
}

