/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit3;

import com.intellij.junit3.TestRunnerUtil;
import com.intellij.rt.execution.junit.ComparisonFailureData;
import com.intellij.rt.execution.junit.IDEAJUnitListener;
import com.intellij.rt.execution.junit.MapSerializerUtil;
import com.intellij.rt.junit.DeafStream;
import com.intellij.rt.junit.IdeaTestRunner;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.textui.ResultPrinter;
import junit.textui.TestRunner;

public class JUnit3IdeaTestRunner
extends TestRunner
implements IdeaTestRunner<Test> {
    private SMTestListener myTestsListener;
    private ArrayList<String> myListeners;

    public JUnit3IdeaTestRunner() {
        super(DeafStream.DEAF_PRINT_STREAM);
    }

    @Override
    public void createListeners(ArrayList<String> listeners, int count) {
        this.myTestsListener = new SMTestListener();
        this.myListeners = listeners;
    }

    @Override
    public int startRunnerWithArgs(String[] args, String name, int count, boolean sendTree) {
        this.setPrinter(new MockResultPrinter());
        try {
            Test suite = TestRunnerUtil.getTestSuite(this, args);
            if (suite == null) {
                return -1;
            }
            return this.doRun(suite).wasSuccessful() ? 0 : -1;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return -2;
        }
    }

    public void clearStatus() {
        super.clearStatus();
    }

    public void runFailed(String message) {
        super.runFailed(message);
    }

    @Override
    public Test getTestToStart(String[] args, String name) {
        return TestRunnerUtil.getTestSuite(this, args);
    }

    @Override
    public List<Test> getChildTests(Test description) {
        return JUnit3IdeaTestRunner.getTestCasesOf(description);
    }

    @Override
    public String getTestClassName(Test child) {
        return child instanceof TestSuite ? ((TestSuite)child).getName() : child.getClass().getName();
    }

    @Override
    public String getStartDescription(Test child) {
        if (child instanceof TestCase) {
            return child.getClass().getName() + "," + ((TestCase)child).getName();
        }
        return child.toString();
    }

    protected TestResult createTestResult() {
        TestResult testResult = super.createTestResult();
        testResult.addListener((TestListener)this.myTestsListener);
        try {
            for (String listener : this.myListeners) {
                final IDEAJUnitListener junitListener = Class.forName(listener).asSubclass(IDEAJUnitListener.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                testResult.addListener(new TestListener(){

                    public void addError(Test test, Throwable t) {
                    }

                    public void addFailure(Test test, AssertionFailedError t) {
                    }

                    public void endTest(Test test) {
                        if (test instanceof TestCase) {
                            junitListener.testFinished(test.getClass().getName(), ((TestCase)test).getName());
                        }
                    }

                    public void startTest(Test test) {
                        if (test instanceof TestCase) {
                            junitListener.testStarted(test.getClass().getName(), ((TestCase)test).getName());
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return testResult;
    }

    public TestResult doRun(Test suite, boolean wait) {
        TestResult testResult = super.doRun(suite, wait);
        this.myTestsListener.finishSuite();
        return testResult;
    }

    static List<Test> getTestCasesOf(Test test) {
        ArrayList<Test> testCases = new ArrayList<Test>();
        if (test instanceof TestRunnerUtil.SuiteMethodWrapper) {
            test = ((TestRunnerUtil.SuiteMethodWrapper)test).getSuite();
        }
        if (test instanceof TestSuite) {
            TestSuite testSuite = (TestSuite)test;
            Enumeration each = testSuite.tests();
            while (each.hasMoreElements()) {
                Test childTest = (Test)each.nextElement();
                if (childTest instanceof TestSuite && !((TestSuite)childTest).tests().hasMoreElements()) continue;
                testCases.add(childTest);
            }
        }
        return testCases;
    }

    private static class SMTestListener
    implements TestListener {
        private String myClassName;
        private long myCurrentTestStart;

        private SMTestListener() {
        }

        public void addError(Test test, Throwable e) {
            this.testFailure(e, "testFailed", SMTestListener.getMethodName(test));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void testFailure(Throwable failure, String messageName, String methodName) {
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put("name", methodName);
            long duration = System.currentTimeMillis() - this.myCurrentTestStart;
            if (duration > 0L) {
                attrs.put("duration", Long.toString(duration));
            }
            try {
                String trace = this.getTrace(failure);
                ComparisonFailureData notification = ComparisonFailureData.create((Throwable)failure);
                ComparisonFailureData.registerSMAttributes((ComparisonFailureData)notification, (String)trace, (String)failure.getMessage(), attrs, (Throwable)failure);
            }
            catch (Throwable e) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter writer = new PrintWriter(stringWriter);
                e.printStackTrace(writer);
                ComparisonFailureData.registerSMAttributes(null, (String)stringWriter.toString(), (String)e.getMessage(), attrs, (Throwable)e);
            }
            finally {
                System.out.println("\n" + MapSerializerUtil.asString((String)messageName, attrs));
            }
        }

        public String getTrace(Throwable failure) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter writer = new PrintWriter(stringWriter);
            failure.printStackTrace(writer);
            return stringWriter.toString();
        }

        private static String getMethodName(Test test) {
            String toString = test.toString();
            int braceIdx = toString.indexOf("(");
            return braceIdx > 0 ? toString.substring(0, braceIdx) : toString;
        }

        private static String getClassName(Test test) {
            String toString = test.toString();
            int braceIdx = toString.indexOf("(");
            return braceIdx > 0 && toString.endsWith(")") ? toString.substring(braceIdx + 1, toString.length() - 1) : null;
        }

        public void addFailure(Test test, AssertionFailedError e) {
            this.addError(test, (Throwable)e);
        }

        public void endTest(Test test) {
            long duration = System.currentTimeMillis() - this.myCurrentTestStart;
            System.out.println("\n##teamcity[testFinished name='" + SMTestListener.escapeName(SMTestListener.getMethodName(test)) + (duration > 0L ? "' duration='" + duration : "") + "']");
        }

        public void startTest(Test test) {
            this.myCurrentTestStart = System.currentTimeMillis();
            String className = SMTestListener.getClassName(test);
            if (className != null && !className.equals(this.myClassName)) {
                this.finishSuite();
                this.myClassName = className;
                System.out.println("##teamcity[testSuiteStarted name ='" + SMTestListener.escapeName(this.myClassName) + "' locationHint='java:suite://" + SMTestListener.escapeName(className) + "']");
            }
            String methodName = SMTestListener.getMethodName(test);
            System.out.println("##teamcity[testStarted name='" + SMTestListener.escapeName(methodName) + "' locationHint='java:test://" + SMTestListener.escapeName(className + "/" + methodName) + "']");
        }

        protected void finishSuite() {
            if (this.myClassName != null) {
                System.out.println("##teamcity[testSuiteFinished name='" + SMTestListener.escapeName(this.myClassName) + "']");
            }
        }

        private static String escapeName(String str) {
            return MapSerializerUtil.escapeStr((String)str, (MapSerializerUtil.EscapeInfoProvider)MapSerializerUtil.STD_ESCAPER);
        }
    }

    public static class MockResultPrinter
    extends ResultPrinter {
        public MockResultPrinter() {
            super(DeafStream.DEAF_PRINT_STREAM);
        }
    }
}

