/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.stats;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.stats.ReportsData;
import org.jetbrains.kotlin.util.CompilerType;
import org.jetbrains.kotlin.util.DynamicStats;
import org.jetbrains.kotlin.util.GarbageCollectionStats;
import org.jetbrains.kotlin.util.PhaseType;
import org.jetbrains.kotlin.util.PlatformType;
import org.jetbrains.kotlin.util.SideStats;
import org.jetbrains.kotlin.util.Time;
import org.jetbrains.kotlin.util.UnitStats;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JD\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0013\"\u000e\b\u0000\u0010\u0014*\b\u0012\u0004\u0012\u0002H\u00140\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u0002H\u00140\u001bJ\u0012\u0010\u001c\u001a\u00020\u001d*\b\u0012\u0004\u0012\u00020\n0\tH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/stats/StatsCalculator;", "", "reportsData", "Lorg/jetbrains/kotlin/stats/ReportsData;", "<init>", "(Lorg/jetbrains/kotlin/stats/ReportsData;)V", "getReportsData", "()Lorg/jetbrains/kotlin/stats/ReportsData;", "unitStats", "", "Lorg/jetbrains/kotlin/util/UnitStats;", "getUnitStats", "()Ljava/util/Collection;", "totalStats", "getTotalStats", "()Lorg/jetbrains/kotlin/util/UnitStats;", "averageStats", "getAverageStats", "getTopModulesBy", "", "R", "", "count", "", "max", "", "selector", "Lkotlin/Function1;", "aggregateStats", "Lorg/jetbrains/kotlin/stats/StatsCalculator$AggregatedStats;", "AggregatedStats", "compiler.common"})
@SourceDebugExtension(value={"SMAP\nStatsCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatsCalculator.kt\norg/jetbrains/kotlin/stats/StatsCalculator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,201:1\n1080#2:202\n1068#2:203\n1915#2,2:205\n1586#2:218\n1661#2,3:219\n1#3:204\n383#4,7:207\n129#5:214\n158#5,3:215\n*S KotlinDebug\n*F\n+ 1 StatsCalculator.kt\norg/jetbrains/kotlin/stats/StatsCalculator\n*L\n78#1:202\n80#1:203\n143#1:205,2\n185#1:218\n185#1:219,3\n150#1:207,7\n179#1:214\n179#1:215,3\n*E\n"})
public final class StatsCalculator {
    @NotNull
    private final ReportsData reportsData;
    @NotNull
    private final Collection<UnitStats> unitStats;
    @NotNull
    private final UnitStats totalStats;
    @NotNull
    private final UnitStats averageStats;

    public StatsCalculator(@NotNull ReportsData reportsData) {
        Intrinsics.checkNotNullParameter((Object)reportsData, (String)"reportsData");
        this.reportsData = reportsData;
        this.unitStats = this.reportsData.getUnitStats();
        AggregatedStats it = this.aggregateStats(this.unitStats);
        boolean bl = false;
        this.totalStats = it.getTotal();
        this.averageStats = it.getAverage();
    }

    @NotNull
    public final ReportsData getReportsData() {
        return this.reportsData;
    }

    @NotNull
    public final Collection<UnitStats> getUnitStats() {
        return this.unitStats;
    }

    @NotNull
    public final UnitStats getTotalStats() {
        return this.totalStats;
    }

    @NotNull
    public final UnitStats getAverageStats() {
        return this.averageStats;
    }

    @NotNull
    public final <R extends Comparable<? super R>> List<UnitStats> getTopModulesBy(int count, boolean max, @NotNull Function1<? super UnitStats, ? extends R> selector) {
        List list;
        Intrinsics.checkNotNullParameter(selector, (String)"selector");
        if (count == 0) {
            return CollectionsKt.emptyList();
        }
        PriorityQueue<UnitStats> priorityQueue = new PriorityQueue<UnitStats>(count, (arg_0, arg_1) -> StatsCalculator.getTopModulesBy$lambda$0(selector, max, arg_0, arg_1));
        Comparable bottomValue = null;
        for (UnitStats unitStat : this.unitStats) {
            boolean replace;
            boolean bl;
            if (priorityQueue.size() < count) {
                priorityQueue.add(unitStat);
                Object e = priorityQueue.peek();
                Intrinsics.checkNotNullExpressionValue(e, (String)"peek(...)");
                bottomValue = (Comparable)selector.invoke(e);
                continue;
            }
            Comparable calculatedSelector = (Comparable)selector.invoke((Object)unitStat);
            if (max) {
                Comparable comparable = bottomValue;
                Intrinsics.checkNotNull(comparable);
                bl = calculatedSelector.compareTo(comparable) > 0;
            } else {
                Comparable comparable = bottomValue;
                Intrinsics.checkNotNull(comparable);
                bl = calculatedSelector.compareTo(comparable) < 0;
            }
            if (!(replace = bl)) continue;
            priorityQueue.poll();
            priorityQueue.add(unitStat);
            Object e = priorityQueue.peek();
            Intrinsics.checkNotNullExpressionValue(e, (String)"peek(...)");
            bottomValue = (Comparable)selector.invoke(e);
        }
        if (max) {
            Iterable $this$sortedByDescending$iv = priorityQueue;
            boolean $i$f$sortedByDescending = false;
            list = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(selector){
                final /* synthetic */ Function1 $selector;
                {
                    this.$selector = $selector;
                }

                public final int compare(T a, T b) {
                    Function1 function1 = this.$selector;
                    return ComparisonsKt.compareValues((Comparable)((Comparable)function1.invoke(b)), (Comparable)((Comparable)function1.invoke(a)));
                }
            });
        } else {
            Iterable $this$sortedBy$iv = priorityQueue;
            boolean $i$f$sortedBy = false;
            list = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(selector){
                final /* synthetic */ Function1 $selector;
                {
                    this.$selector = $selector;
                }

                public final int compare(T a, T b) {
                    Function1 function1 = this.$selector;
                    return ComparisonsKt.compareValues((Comparable)((Comparable)function1.invoke(a)), (Comparable)((Comparable)function1.invoke(b)));
                }
            });
        }
        return list;
    }

    public static /* synthetic */ List getTopModulesBy$default(StatsCalculator statsCalculator, int n, boolean bl, Function1 function1, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        if ((n2 & 2) != 0) {
            bl = true;
        }
        return statsCalculator.getTopModulesBy(n, bl, function1);
    }

    /*
     * WARNING - void declaration
     */
    private final AggregatedStats aggregateStats(Collection<UnitStats> $this$aggregateStats) {
        if (!(!$this$aggregateStats.isEmpty())) {
            boolean $i$a$-require-StatsCalculator$aggregateStats$22 = false;
            String $i$a$-require-StatsCalculator$aggregateStats$22 = "At least one entry is required";
            throw new IllegalArgumentException($i$a$-require-StatsCalculator$aggregateStats$22.toString());
        }
        if ($this$aggregateStats.size() == 1) {
            UnitStats it = (UnitStats)CollectionsKt.first((Iterable)$this$aggregateStats);
            boolean bl = false;
            return new AggregatedStats(it, it);
        }
        Ref.ObjectRef name2 = new Ref.ObjectRef();
        Ref.ObjectRef outputKind = new Ref.ObjectRef();
        Ref.ObjectRef latestCurrentTimeMs = new Ref.ObjectRef();
        Ref.ObjectRef platform = new Ref.ObjectRef();
        Ref.ObjectRef compilerType = new Ref.ObjectRef();
        Ref.BooleanRef hasErrors = new Ref.BooleanRef();
        Ref.LongRef filesCount = new Ref.LongRef();
        Ref.LongRef linesCount = new Ref.LongRef();
        Ref.ObjectRef initStats = new Ref.ObjectRef();
        initStats.element = Time.Companion.getZERO();
        Ref.ObjectRef analysisStats = new Ref.ObjectRef();
        analysisStats.element = Time.Companion.getZERO();
        Ref.ObjectRef translationToIrStats = new Ref.ObjectRef();
        translationToIrStats.element = Time.Companion.getZERO();
        Ref.ObjectRef irPreLoweringStats = new Ref.ObjectRef();
        irPreLoweringStats.element = Time.Companion.getZERO();
        Ref.ObjectRef irSerializationStats = new Ref.ObjectRef();
        irSerializationStats.element = Time.Companion.getZERO();
        Ref.ObjectRef klibWritingStats = new Ref.ObjectRef();
        klibWritingStats.element = Time.Companion.getZERO();
        Ref.ObjectRef irLoweringStats = new Ref.ObjectRef();
        irLoweringStats.element = Time.Companion.getZERO();
        Ref.ObjectRef backendStats = new Ref.ObjectRef();
        backendStats.element = Time.Companion.getZERO();
        LinkedHashMap<Pair<PhaseType, String>, Time> dynamicStats = new LinkedHashMap<Pair<PhaseType, String>, Time>();
        Ref.ObjectRef findJavaClassStats = new Ref.ObjectRef();
        findJavaClassStats.element = SideStats.Companion.getEMPTY();
        Ref.ObjectRef findKotlinClassStats = new Ref.ObjectRef();
        findKotlinClassStats.element = SideStats.Companion.getEMPTY();
        Map gcStats = new LinkedHashMap();
        Ref.LongRef jitTimeMillis = new Ref.LongRef();
        for (UnitStats moduleStats : $this$aggregateStats) {
            if (name2.element == null) {
                name2.element = moduleStats.getName();
            } else if (!Intrinsics.areEqual((Object)name2.element, (Object)moduleStats.getName())) {
                name2.element = "Aggregate";
            }
            if (outputKind.element == null) {
                outputKind.element = moduleStats.getName();
            } else if (!Intrinsics.areEqual((Object)outputKind.element, (Object)moduleStats.getOutputKind())) {
                name2.element = "Aggregate";
            }
            if (latestCurrentTimeMs.element == null || ((Number)latestCurrentTimeMs.element).longValue() < moduleStats.getTimeStampMs()) {
                latestCurrentTimeMs.element = moduleStats.getTimeStampMs();
            }
            if (platform.element == null) {
                platform.element = moduleStats.getPlatform();
            } else if (platform.element != moduleStats.getPlatform()) {
                System.out.println((Object)("The module " + moduleStats.getName() + " is ignored because it has different platform " + (Object)((Object)moduleStats.getPlatform()) + " (not " + platform.element));
            }
            compilerType.element = moduleStats.getCompilerType().plus((CompilerType)((Object)compilerType.element));
            hasErrors.element = hasErrors.element || moduleStats.getHasErrors();
            filesCount.element += (long)moduleStats.getFilesCount();
            linesCount.element += (long)moduleStats.getLinesCount();
            initStats.element = ((Time)initStats.element).plus(moduleStats.getInitStats());
            analysisStats.element = ((Time)analysisStats.element).plus(moduleStats.getAnalysisStats());
            translationToIrStats.element = ((Time)translationToIrStats.element).plus(moduleStats.getTranslationToIrStats());
            irPreLoweringStats.element = ((Time)irPreLoweringStats.element).plus(moduleStats.getIrPreLoweringStats());
            irSerializationStats.element = ((Time)irSerializationStats.element).plus(moduleStats.getIrSerializationStats());
            klibWritingStats.element = ((Time)klibWritingStats.element).plus(moduleStats.getKlibWritingStats());
            irLoweringStats.element = ((Time)irLoweringStats.element).plus(moduleStats.getIrLoweringStats());
            backendStats.element = ((Time)backendStats.element).plus(moduleStats.getBackendStats());
            List<DynamicStats> list = moduleStats.getDynamicStats();
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    DynamicStats dynamicStats2 = (DynamicStats)element$iv;
                    boolean bl = false;
                    PhaseType parentPhase = dynamicStats2.component1();
                    String name3 = dynamicStats2.component2();
                    Time time = dynamicStats2.component3();
                    Map map = dynamicStats;
                    Pair pair = TuplesKt.to((Object)((Object)parentPhase), (Object)name3);
                    Time time2 = dynamicStats.get(TuplesKt.to((Object)((Object)parentPhase), (Object)name3));
                    if (time2 == null) {
                        time2 = Time.Companion.getZERO();
                    }
                    Time time3 = time2.plus(time);
                    map.put(pair, time3);
                }
            }
            findJavaClassStats.element = ((SideStats)findJavaClassStats.element).plus(moduleStats.getFindJavaClassStats());
            findKotlinClassStats.element = ((SideStats)findKotlinClassStats.element).plus(moduleStats.getFindKotlinClassStats());
            for (GarbageCollectionStats gcInfo : moduleStats.getGcStats()) {
                Object object;
                void $this$getOrPut$iv;
                Object element$iv;
                String gcKind = gcInfo.getKind();
                element$iv = gcStats;
                String key$iv = gcKind;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    Pair answer$iv = TuplesKt.to((Object)new GarbageCollectionStats(gcKind, 0L, 0L), (Object)0L);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                Pair pair = (Pair)object;
                GarbageCollectionStats existingGcStats = (GarbageCollectionStats)pair.component1();
                long count = ((Number)pair.component2()).longValue();
                gcStats.put(gcKind, TuplesKt.to((Object)new GarbageCollectionStats(gcKind, existingGcStats.getMillis() + gcInfo.getMillis(), existingGcStats.getCount() + gcInfo.getCount()), (Object)(count + 1L)));
            }
            Long l = moduleStats.getJitTimeMillis();
            jitTimeMillis.element = jitTimeMillis.element + (l != null ? l : 0L);
        }
        return new AggregatedStats(StatsCalculator.aggregateStats$getStats((Ref.ObjectRef<String>)name2, (Ref.ObjectRef<String>)outputKind, (Ref.ObjectRef<Long>)latestCurrentTimeMs, (Ref.ObjectRef<PlatformType>)platform, (Ref.ObjectRef<CompilerType>)compilerType, hasErrors, filesCount, linesCount, (Ref.ObjectRef<Time>)initStats, (Ref.ObjectRef<Time>)analysisStats, (Ref.ObjectRef<Time>)translationToIrStats, (Ref.ObjectRef<Time>)irPreLoweringStats, (Ref.ObjectRef<Time>)irSerializationStats, (Ref.ObjectRef<Time>)klibWritingStats, (Ref.ObjectRef<Time>)irLoweringStats, (Ref.ObjectRef<Time>)backendStats, dynamicStats, (Ref.ObjectRef<SideStats>)findJavaClassStats, (Ref.ObjectRef<SideStats>)findKotlinClassStats, gcStats, jitTimeMillis, $this$aggregateStats, true), StatsCalculator.aggregateStats$getStats((Ref.ObjectRef<String>)name2, (Ref.ObjectRef<String>)outputKind, (Ref.ObjectRef<Long>)latestCurrentTimeMs, (Ref.ObjectRef<PlatformType>)platform, (Ref.ObjectRef<CompilerType>)compilerType, hasErrors, filesCount, linesCount, (Ref.ObjectRef<Time>)initStats, (Ref.ObjectRef<Time>)analysisStats, (Ref.ObjectRef<Time>)translationToIrStats, (Ref.ObjectRef<Time>)irPreLoweringStats, (Ref.ObjectRef<Time>)irSerializationStats, (Ref.ObjectRef<Time>)klibWritingStats, (Ref.ObjectRef<Time>)irLoweringStats, (Ref.ObjectRef<Time>)backendStats, dynamicStats, (Ref.ObjectRef<SideStats>)findJavaClassStats, (Ref.ObjectRef<SideStats>)findKotlinClassStats, gcStats, jitTimeMillis, $this$aggregateStats, false));
    }

    private static final int getTopModulesBy$lambda$0(Function1 $selector, boolean $max, UnitStats o1, UnitStats o2) {
        Intrinsics.checkNotNull((Object)o1);
        Comparable value1 = (Comparable)$selector.invoke((Object)o1);
        Intrinsics.checkNotNull((Object)o2);
        Comparable value2 = (Comparable)$selector.invoke((Object)o2);
        return $max ? value1.compareTo(value2) : value2.compareTo(value1);
    }

    /*
     * WARNING - void declaration
     */
    private static final UnitStats aggregateStats$getStats(Ref.ObjectRef<String> name2, Ref.ObjectRef<String> outputKind, Ref.ObjectRef<Long> latestCurrentTimeMs, Ref.ObjectRef<PlatformType> platform, Ref.ObjectRef<CompilerType> compilerType, Ref.BooleanRef hasErrors, Ref.LongRef filesCount, Ref.LongRef linesCount, Ref.ObjectRef<Time> initStats, Ref.ObjectRef<Time> analysisStats, Ref.ObjectRef<Time> translationToIrStats, Ref.ObjectRef<Time> irPreLoweringStats, Ref.ObjectRef<Time> irSerializationStats, Ref.ObjectRef<Time> klibWritingStats, Ref.ObjectRef<Time> irLoweringStats, Ref.ObjectRef<Time> backendStats, LinkedHashMap<Pair<PhaseType, String>, Time> dynamicStats, Ref.ObjectRef<SideStats> findJavaClassStats, Ref.ObjectRef<SideStats> findKotlinClassStats, Map<String, Pair<GarbageCollectionStats, Long>> gcStats, Ref.LongRef jitTimeMillis, Collection<UnitStats> $this_aggregateStats, boolean total) {
        Collection<GarbageCollectionStats> collection;
        Collection<DynamicStats> collection2;
        Pair pair;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        long it;
        String string = (String)name2.element;
        String string2 = (String)outputKind.element;
        Long l = (Long)latestCurrentTimeMs.element;
        long l2 = l != null ? l : System.currentTimeMillis();
        Object object = platform.element;
        Intrinsics.checkNotNull((Object)object);
        PlatformType platformType = (PlatformType)((Object)object);
        CompilerType compilerType2 = (CompilerType)((Object)compilerType.element);
        if (compilerType2 == null) {
            compilerType2 = CompilerType.K1andK2;
        }
        long l3 = filesCount.element;
        boolean bl = hasErrors.element;
        CompilerType compilerType3 = compilerType2;
        PlatformType platformType2 = platformType;
        long l4 = l2;
        String string3 = string2;
        String string4 = string;
        boolean bl2 = false;
        void var52_38 = total ? it : it / (long)$this_aggregateStats.size();
        it = linesCount.element;
        int n = (int)var52_38;
        boolean bl3 = false;
        long l5 = total ? it : it / (long)$this_aggregateStats.size();
        Time it2 = (Time)initStats.element;
        int n2 = (int)l5;
        boolean bl4 = false;
        Time time = total ? it2 : it2.div($this_aggregateStats.size());
        it2 = (Time)analysisStats.element;
        boolean bl5 = false;
        Time time2 = total ? it2 : it2.div($this_aggregateStats.size());
        it2 = (Time)translationToIrStats.element;
        boolean bl6 = false;
        Time time3 = total ? it2 : it2.div($this_aggregateStats.size());
        it2 = (Time)irPreLoweringStats.element;
        boolean bl7 = false;
        Time time4 = total ? it2 : it2.div($this_aggregateStats.size());
        it2 = (Time)irSerializationStats.element;
        boolean bl8 = false;
        Time time5 = total ? it2 : it2.div($this_aggregateStats.size());
        it2 = (Time)klibWritingStats.element;
        boolean bl9 = false;
        Time time6 = total ? it2 : it2.div($this_aggregateStats.size());
        it2 = (Time)irLoweringStats.element;
        boolean bl10 = false;
        Time time7 = total ? it2 : it2.div($this_aggregateStats.size());
        it2 = (Time)backendStats.element;
        boolean $i$a$-let-StatsCalculator$aggregateStats$getStats$112 = false;
        Time time8 = total ? it2 : it2.div($this_aggregateStats.size());
        Map map = dynamicStats;
        boolean $i$f$map22 = false;
        void $i$a$-let-StatsCalculator$aggregateStats$getStats$112 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Pair item$iv$iv;
            pair = item$iv$iv = iterator2.next();
            collection2 = destination$iv$iv;
            boolean bl11 = false;
            Pair key = (Pair)pair.getKey();
            Time time9 = (Time)pair.getValue();
            PhaseType phaseType = (PhaseType)((Object)key.component1());
            String name3 = (String)key.component2();
            collection2.add(new DynamicStats(phaseType, name3, total ? time9 : time9.div($this_aggregateStats.size())));
        }
        collection2 = (List)destination$iv$iv;
        SideStats $i$f$map22 = (SideStats)findJavaClassStats.element;
        boolean bl12 = false;
        void var65_67 = total ? it3 : it3.div($this_aggregateStats.size());
        SideStats it3 = (SideStats)findKotlinClassStats.element;
        boolean $i$a$-let-StatsCalculator$aggregateStats$getStats$142 = false;
        SideStats sideStats = total ? it3 : it3.div($this_aggregateStats.size());
        $this$map$iv = gcStats.values();
        boolean $i$f$map32 = false;
        Iterable $i$a$-let-StatsCalculator$aggregateStats$getStats$142 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Pair item$iv$iv : $this$mapTo$iv$iv) {
            long it4;
            void gcStatsToCount;
            pair = item$iv$iv;
            collection = destination$iv$iv;
            boolean bl13 = false;
            GarbageCollectionStats gcStats2 = (GarbageCollectionStats)gcStatsToCount.component1();
            long count = ((Number)gcStatsToCount.component2()).longValue();
            long name3 = gcStats2.getMillis();
            String string5 = gcStats2.getKind();
            boolean bl14 = false;
            void var39_71 = total ? it4 : it4 / count;
            it4 = gcStats2.getCount();
            void var41_72 = var39_71;
            boolean bl15 = false;
            long l6 = total ? it4 : it4 / count;
            long l7 = l6;
            void var71_76 = var41_72;
            String string6 = string5;
            collection.add(new GarbageCollectionStats(string6, (long)var71_76, l7));
        }
        collection = (List)destination$iv$iv;
        long $i$f$map32 = jitTimeMillis.element;
        boolean bl16 = false;
        Long l8 = (long)(total ? it : it / (long)$this_aggregateStats.size());
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n3 = 0x200000;
        List list = null;
        Long l9 = l8;
        Collection<GarbageCollectionStats> collection3 = collection;
        SideStats sideStats2 = sideStats;
        void var80_85 = var65_67;
        Collection<DynamicStats> collection4 = collection2;
        Time time10 = time8;
        Time time11 = time7;
        Time time12 = time6;
        Time time13 = time5;
        Time time14 = time4;
        Time time15 = time3;
        Time time16 = time2;
        Time time17 = time;
        int n4 = n2;
        int n5 = n;
        boolean bl17 = bl;
        CompilerType compilerType4 = compilerType3;
        PlatformType platformType3 = platformType2;
        long l10 = l4;
        String string7 = string3;
        String string8 = string4;
        return new UnitStats(string8, string7, l10, platformType3, compilerType4, bl17, n5, n4, time17, time16, time15, time14, time13, time12, time11, time10, (List)collection4, (SideStats)var80_85, sideStats2, (List)collection3, l9, list, n3, defaultConstructorMarker);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/stats/StatsCalculator$AggregatedStats;", "", "total", "Lorg/jetbrains/kotlin/util/UnitStats;", "average", "<init>", "(Lorg/jetbrains/kotlin/util/UnitStats;Lorg/jetbrains/kotlin/util/UnitStats;)V", "getTotal", "()Lorg/jetbrains/kotlin/util/UnitStats;", "getAverage", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "compiler.common"})
    public static final class AggregatedStats {
        @NotNull
        private final UnitStats total;
        @NotNull
        private final UnitStats average;

        public AggregatedStats(@NotNull UnitStats total, @NotNull UnitStats average) {
            Intrinsics.checkNotNullParameter((Object)total, (String)"total");
            Intrinsics.checkNotNullParameter((Object)average, (String)"average");
            this.total = total;
            this.average = average;
        }

        @NotNull
        public final UnitStats getTotal() {
            return this.total;
        }

        @NotNull
        public final UnitStats getAverage() {
            return this.average;
        }

        @NotNull
        public final UnitStats component1() {
            return this.total;
        }

        @NotNull
        public final UnitStats component2() {
            return this.average;
        }

        @NotNull
        public final AggregatedStats copy(@NotNull UnitStats total, @NotNull UnitStats average) {
            Intrinsics.checkNotNullParameter((Object)total, (String)"total");
            Intrinsics.checkNotNullParameter((Object)average, (String)"average");
            return new AggregatedStats(total, average);
        }

        public static /* synthetic */ AggregatedStats copy$default(AggregatedStats aggregatedStats, UnitStats unitStats, UnitStats unitStats2, int n, Object object) {
            if ((n & 1) != 0) {
                unitStats = aggregatedStats.total;
            }
            if ((n & 2) != 0) {
                unitStats2 = aggregatedStats.average;
            }
            return aggregatedStats.copy(unitStats, unitStats2);
        }

        @NotNull
        public String toString() {
            return "AggregatedStats(total=" + this.total + ", average=" + this.average + ')';
        }

        public int hashCode() {
            int result2 = this.total.hashCode();
            result2 = result2 * 31 + this.average.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AggregatedStats)) {
                return false;
            }
            AggregatedStats aggregatedStats = (AggregatedStats)other;
            if (!Intrinsics.areEqual((Object)this.total, (Object)aggregatedStats.total)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.average, (Object)aggregatedStats.average);
        }
    }
}

