/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions.branch;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import git4idea.actions.branch.GitSingleBranchAction;
import git4idea.actions.ref.GitSingleRefAction;
import git4idea.branch.GitBrancher;
import git4idea.branch.GitNewBranchDialog;
import git4idea.branch.GitNewBranchOptions;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitBranchActionsUtilKt;
import git4idea.ui.branch.GitBranchPopupActions;
import git4idea.ui.branch.GitCheckoutAndRebaseRemoteBranchWorkflow;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0014J.\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J.\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J&\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0011\u001a\u00020\u0014H\u0002J0\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0011\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lgit4idea/actions/branch/GitCheckoutWithRebaseAction;", "Lgit4idea/actions/branch/GitSingleBranchAction;", "<init>", "()V", "isEnabledForRef", "", "ref", "Lgit4idea/GitBranch;", "repositories", "", "Lgit4idea/repo/GitRepository;", "updateIfEnabledAndVisible", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "branch", "actionPerformed", "checkoutAndRebaseRemote", "Lgit4idea/GitRemoteBranch;", "askBranchName", "Lgit4idea/branch/GitNewBranchOptions;", "suggestedLocalName", "", "intellij.vcs.git"})
public final class GitCheckoutWithRebaseAction
extends GitSingleBranchAction {
    public GitCheckoutWithRebaseAction() {
        Supplier<String> supplier = GitBundle.messagePointer("branches.checkout.and.rebase.onto.current", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
        super(supplier);
    }

    @Override
    protected boolean isEnabledForRef(@NotNull GitBranch ref, @NotNull List<? extends GitRepository> repositories) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        return !GitSingleRefAction.Companion.isCurrentRefInAnyRepo$intellij_vcs_git(ref, repositories);
    }

    @Override
    public void updateIfEnabledAndVisible(@NotNull AnActionEvent e, @NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull GitBranch branch) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        Object[] objectArray = new Object[]{GitBranchPopupActions.getSelectedBranchFullPresentation(branch.getName()), GitBranchPopupActions.getCurrentBranchFullPresentation(project, (Collection<? extends GitRepository>)repositories), branch.getName()};
        String string = GitBundle.message("branches.checkout.and.rebase.onto.in.one.step", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String description = string;
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        objectArray = new Object[]{GitBranchPopupActions.getCurrentBranchTruncatedPresentation(project, (Collection<? extends GitRepository>)repositories)};
        presentation2.setText(GitBundle.message("branches.checkout.and.rebase.onto.branch", objectArray));
        presentation2.setDescription(description);
        GitBranchPopupActions.addTooltipText(presentation2, description);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull GitBranch branch) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        if (branch instanceof GitRemoteBranch) {
            this.checkoutAndRebaseRemote(project, repositories, (GitRemoteBranch)branch);
        } else {
            GitBrancher.getInstance(project).rebaseOnCurrent(repositories, branch.getName());
        }
    }

    private final void checkoutAndRebaseRemote(Project project, List<? extends GitRepository> repositories, GitRemoteBranch branch) {
        String suggestedLocalName = branch.getNameForRemoteOperations();
        GitNewBranchOptions newBranchOptions = new GitNewBranchOptions(suggestedLocalName, false, true, false, repositories, false, 32, null);
        if (GitReference.BRANCH_NAME_HASHING_STRATEGY.equals((Object)branch.getName(), (Object)suggestedLocalName)) {
            newBranchOptions = this.askBranchName(project, repositories, branch, suggestedLocalName);
        }
        if (newBranchOptions == null) {
            return;
        }
        String localName = newBranchOptions.getName();
        List selectedRepositories = CollectionsKt.toList((Iterable)newBranchOptions.repositories());
        Map map2 = ContainerUtil.map2MapNotNull((Collection)selectedRepositories, arg_0 -> GitCheckoutWithRebaseAction.checkoutAndRebaseRemote$lambda$1(arg_0 -> GitCheckoutWithRebaseAction.checkoutAndRebaseRemote$lambda$0(localName, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"map2MapNotNull(...)");
        Map conflictingLocalBranches = map2;
        if (GitBranchActionsUtilKt.hasTrackingConflicts(conflictingLocalBranches, branch.getName())) {
            newBranchOptions = this.askBranchName(project, selectedRepositories, branch, localName);
        }
        if (newBranchOptions == null) {
            return;
        }
        selectedRepositories = CollectionsKt.toList((Iterable)newBranchOptions.repositories());
        GitCheckoutAndRebaseRemoteBranchWorkflow workflow = new GitCheckoutAndRebaseRemoteBranchWorkflow(project, selectedRepositories);
        workflow.execute(branch.getNameForLocalOperations(), newBranchOptions);
    }

    private final GitNewBranchOptions askBranchName(Project project, List<? extends GitRepository> repositories, GitRemoteBranch branch, String suggestedLocalName) {
        Collection collection = repositories;
        Object[] objectArray = new Object[]{branch.getName()};
        String string = GitBundle.message("branches.checkout.s", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return new GitNewBranchDialog(project, collection, string, suggestedLocalName, false, true, false, false, false, null, 960, null).showAndGetOptions();
    }

    private static final Pair checkoutAndRebaseRemote$lambda$0(String $localName, GitRepository r) {
        GitLocalBranch local;
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        GitLocalBranch gitLocalBranch = local = r.getBranches().findLocalBranch($localName);
        return gitLocalBranch != null ? Pair.create((Object)r, (Object)gitLocalBranch) : null;
    }

    private static final Pair checkoutAndRebaseRemote$lambda$1(Function1 $tmp0, Object p0) {
        return (Pair)$tmp0.invoke(p0);
    }
}

