/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.Processor;
import com.intellij.util.TimeoutUtil;
import org.jetbrains.idea.svn.api.ErrorCode;
import org.jetbrains.idea.svn.commandLine.SvnBindException;

public abstract class RepeatSvnActionThroughBusy {
    public static final int REPEAT = 10;
    public static final Processor<Exception> ourBusyExceptionProcessor = e -> {
        if (e instanceof SvnBindException) {
            return ((SvnBindException)((Object)((Object)e))).contains(ErrorCode.WC_LOCKED);
        }
        return false;
    };
    protected int myCnt = 10;
    protected long myTimeout = 50L;
    protected Object myT;

    protected abstract void executeImpl() throws VcsException;

    public <T> T compute() throws VcsException {
        this.execute();
        return (T)this.myT;
    }

    public void execute() throws VcsException {
        while (true) {
            try {
                this.executeImpl();
            }
            catch (VcsException e) {
                if (ourBusyExceptionProcessor.process((Object)e) && this.myCnt > 0) {
                    TimeoutUtil.sleep((long)(this.myTimeout * (long)(10 - this.myCnt + 1)));
                    --this.myCnt;
                    continue;
                }
                throw e;
            }
            break;
        }
    }
}

