/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.GrPsiUpdateIntention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ParenthesesUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyConstantExpressionEvaluator;

public final class SimplifyTernaryOperatorIntention
extends GrPsiUpdateIntention {
    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull ActionContext context, @NotNull ModPsiUpdater updater) {
        if (element == null) {
            SimplifyTernaryOperatorIntention.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SimplifyTernaryOperatorIntention.$$$reportNull$$$0(1);
        }
        if (updater == null) {
            SimplifyTernaryOperatorIntention.$$$reportNull$$$0(2);
        }
        if (!(element instanceof GrConditionalExpression)) {
            throw new IncorrectOperationException("Not invoked on a conditional");
        }
        GrConditionalExpression condExp = (GrConditionalExpression)element;
        GrExpression thenBranch = condExp.getThenBranch();
        GrExpression elseBranch = condExp.getElseBranch();
        Object thenVal = GroovyConstantExpressionEvaluator.evaluate(thenBranch);
        if (Boolean.TRUE.equals(thenVal) && elseBranch != null) {
            GrExpression conditionExp = condExp.getCondition();
            String conditionExpText = SimplifyTernaryOperatorIntention.getStringToPutIntoOrExpression(conditionExp);
            String elseExpText = SimplifyTernaryOperatorIntention.getStringToPutIntoOrExpression(elseBranch);
            String newExp = conditionExpText + "||" + elseExpText;
            SimplifyTernaryOperatorIntention.manageReplace(updater, condExp, conditionExpText, newExp);
            return;
        }
        Object elseVal = GroovyConstantExpressionEvaluator.evaluate(elseBranch);
        if (Boolean.FALSE.equals(elseVal) && thenBranch != null) {
            GrExpression conditionExp = condExp.getCondition();
            String conditionExpText = SimplifyTernaryOperatorIntention.getStringToPutIntoAndExpression(conditionExp);
            String thenExpText = SimplifyTernaryOperatorIntention.getStringToPutIntoAndExpression(thenBranch);
            String newExp = conditionExpText + "&&" + thenExpText;
            SimplifyTernaryOperatorIntention.manageReplace(updater, condExp, conditionExpText, newExp);
        }
    }

    private static void manageReplace(ModPsiUpdater updater, GrConditionalExpression condExp, String conditionExpText, String newExp) {
        int caretOffset = conditionExpText.length() + 2;
        GrExpression expressionFromText = GroovyPsiElementFactory.getInstance(condExp.getProject()).createExpressionFromText(newExp, condExp.getContext());
        expressionFromText = (GrExpression)condExp.replace(expressionFromText);
        updater.moveCaretTo(expressionFromText.getTextOffset() + caretOffset);
    }

    @NotNull
    private static String getStringToPutIntoAndExpression(GrExpression expression) {
        Object expressionText = expression.getText();
        if (ParenthesesUtils.AND_PRECEDENCE < ParenthesesUtils.getPrecedence(expression)) {
            expressionText = "(" + (String)expressionText + ")";
        }
        String string = expressionText;
        if (string == null) {
            SimplifyTernaryOperatorIntention.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    private static String getStringToPutIntoOrExpression(GrExpression expression) {
        Object expressionText = expression.getText();
        if (ParenthesesUtils.OR_PRECEDENCE < ParenthesesUtils.getPrecedence(expression)) {
            expressionText = "(" + (String)expressionText + ")";
        }
        String string = expressionText;
        if (string == null) {
            SimplifyTernaryOperatorIntention.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = element -> {
            if (!(element instanceof GrConditionalExpression)) {
                return false;
            }
            GrConditionalExpression condExp = (GrConditionalExpression)element;
            PsiType condType = condExp.getType();
            if (condType == null || !PsiTypes.booleanType().isConvertibleFrom(condType)) {
                return false;
            }
            GrExpression thenBranch = condExp.getThenBranch();
            GrExpression elseBranch = condExp.getElseBranch();
            Object thenVal = GroovyConstantExpressionEvaluator.evaluate(thenBranch);
            if (Boolean.TRUE.equals(thenVal) && elseBranch != null) {
                return true;
            }
            Object elseVal = GroovyConstantExpressionEvaluator.evaluate(elseBranch);
            return thenBranch != null && Boolean.FALSE.equals(elseVal);
        };
        if (psiElementPredicate == null) {
            SimplifyTernaryOperatorIntention.$$$reportNull$$$0(5);
        }
        return psiElementPredicate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/intentions/control/SimplifyTernaryOperatorIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/control/SimplifyTernaryOperatorIntention";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringToPutIntoAndExpression";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringToPutIntoOrExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

